/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpMethodReleaseInputStream;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.NullInputStream;
import org.apache.http.HttpResponse;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2DownloadFileResponse;

public class B2ReadFeature
implements Read {
    private final B2Session session;
    private final B2VersionIdProvider fileid;

    public B2ReadFeature(B2Session session, B2VersionIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (file.getType().contains(AbstractPath.Type.upload)) {
                return new NullInputStream(0L);
            }
            if (status.isAppend()) {
                HttpRange range = HttpRange.withStatus((TransferStatus)status);
                return ((B2ApiClient)this.session.getClient()).downloadFileRangeByIdToStream(this.fileid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener()), range.getStart(), range.getEnd());
            }
            B2DownloadFileResponse response = ((B2ApiClient)this.session.getClient()).downloadFileById(this.fileid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener()));
            return new HttpMethodReleaseInputStream((HttpResponse)response.getResponse(), status);
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.fileid).map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }
}

