/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.preferences.HostPreferences;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.Action;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2ListFilesResponse;

public class B2ObjectListService
implements ListService {
    private static final Logger log = LogManager.getLogger(B2ObjectListService.class);
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final B2Session session;
    private final int chunksize;
    private final B2VersionIdProvider fileid;

    public B2ObjectListService(B2Session session, B2VersionIdProvider fileid) {
        this(session, fileid, new HostPreferences(session.getHost()).getInteger("b2.listing.chunksize"));
    }

    public B2ObjectListService(B2Session session, B2VersionIdProvider fileid, int chunksize) {
        this.session = session;
        this.fileid = fileid;
        this.chunksize = chunksize;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList objects = new AttributedList();
            Marker marker = new Marker(this.createPrefix(directory), null);
            String containerId = this.fileid.getVersionId(this.containerService.getContainer(directory), (ListProgressListener)new DisabledListProgressListener());
            HashMap<String, Long> revisions = new HashMap<String, Long>();
            boolean hasDirectoryPlaceholder = this.containerService.isContainer(directory);
            do {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("List directory %s with marker %s", directory, marker));
                }
                B2ListFilesResponse response = ((B2ApiClient)this.session.getClient()).listFileVersions(containerId, marker.nextFilename, marker.nextFileId, Integer.valueOf(this.chunksize), this.createPrefix(directory), String.valueOf('/'));
                marker = this.parse(directory, (AttributedList<Path>)objects, response, revisions);
                if (null == marker.nextFileId && !response.getFiles().isEmpty()) {
                    hasDirectoryPlaceholder = true;
                }
                listener.chunk(directory, objects);
            } while (marker.hasNext());
            if (!hasDirectoryPlaceholder && objects.isEmpty()) {
                throw new NotfoundException(directory.getAbsolute());
            }
            return objects;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.fileid).map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    private String createPrefix(Path directory) {
        return this.containerService.isContainer(directory) ? "" : (directory.isDirectory() ? String.format("%s%s", this.containerService.getKey(directory), Character.valueOf('/')) : this.containerService.getKey(directory));
    }

    private Marker parse(Path directory, AttributedList<Path> objects, B2ListFilesResponse response, Map<String, Long> revisions) {
        B2AttributesFinderFeature attr = new B2AttributesFinderFeature(this.session, this.fileid);
        for (B2FileInfoResponse info : response.getFiles()) {
            if (StringUtils.equals((CharSequence)PathNormalizer.name((String)info.getFileName()), (CharSequence)".bzEmpty")) continue;
            if (directory.isFile() && !StringUtils.equals((CharSequence)directory.getName(), (CharSequence)PathNormalizer.name((String)info.getFileName()))) {
                log.warn(String.format("Skip %s not matching %s", info, directory.getName()));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)info.getFileId())) {
                Path placeholder = new Path(directory.isDirectory() ? directory : directory.getParent(), PathNormalizer.name((String)info.getFileName()), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.placeholder));
                objects.add((Referenceable)placeholder);
                continue;
            }
            PathAttributes attributes = attr.toAttributes(info);
            long revision = 0L;
            if (revisions.containsKey(info.getFileName())) {
                attributes.setDuplicate(true);
                revision = revisions.get(info.getFileName()) + 1L;
                attributes.setRevision(Long.valueOf(revision));
            }
            revisions.put(info.getFileName(), revision);
            Path f = new Path(directory.isDirectory() ? directory : directory.getParent(), PathNormalizer.name((String)info.getFileName()), info.getAction() == Action.start ? EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.upload) : EnumSet.of(AbstractPath.Type.file), attributes);
            this.fileid.cache(f, info.getFileId());
            objects.add((Referenceable)f);
        }
        if (null == response.getNextFileName()) {
            return new Marker(response.getNextFileName(), response.getNextFileId());
        }
        return new Marker(response.getNextFileName(), response.getNextFileId());
    }

    private static final class Marker {
        public final String nextFilename;
        public final String nextFileId;

        public Marker(String nextFilename, String nextFileId) {
            this.nextFilename = nextFilename;
            this.nextFileId = nextFileId;
        }

        public boolean hasNext() {
            return this.nextFilename != null;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Marker{");
            sb.append("nextFilename='").append(this.nextFilename).append('\'');
            sb.append(", nextFileId='").append(this.nextFileId).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

