/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.io.HashAlgorithm;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.B2FinishLargeFileResponse;
import synapticloop.b2.response.B2GetUploadUrlResponse;
import synapticloop.b2.response.B2StartLargeFileResponse;
import synapticloop.b2.response.B2UploadPartResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2LargeUploadWriteFeature
implements MultipartWrite<BaseB2Response> {
    private static final Logger log = LogManager.getLogger(B2LargeUploadWriteFeature.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;

    public B2LargeUploadWriteFeature(B2Session session, B2VersionIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public StatusOutputStream<BaseB2Response> write(Path file, TransferStatus status, ConnectionCallback callback) {
        final LargeUploadOutputStream proxy = new LargeUploadOutputStream(file, status);
        return new HttpResponseOutputStream<BaseB2Response>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(new HostPreferences(this.session.getHost()).getInteger("b2.upload.largeobject.size.minimum"))), (AttributesAdapter)new B2AttributesFinderFeature(this.session, this.fileid), status){

            public BaseB2Response getStatus() {
                return proxy.getFinishLargeFileResponse();
            }
        };
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    private final class LargeUploadOutputStream
    extends OutputStream {
        final List<B2UploadPartResponse> completed = new ArrayList<B2UploadPartResponse>();
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<IOException> canceled = new AtomicReference();
        private final AtomicReference<B2StartLargeFileResponse> startLargeFileResponse = new AtomicReference();
        private final AtomicReference<BaseB2Response> finishLargeFileResponse = new AtomicReference();
        private int partNumber;

        public LargeUploadOutputStream(Path file, TransferStatus status) {
            this.file = file;
            this.overall = status;
        }

        @Override
        public void write(int value) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(final byte[] content, final int off, final int len) throws IOException {
            try {
                if (null != this.canceled.get()) {
                    throw this.canceled.get();
                }
                HashMap<String, String> fileinfo = new HashMap<String, String>(this.overall.getMetadata());
                if (null != this.overall.getTimestamp()) {
                    fileinfo.put("src_last_modified_millis", String.valueOf(this.overall.getTimestamp()));
                }
                if (0 == this.partNumber && len < new HostPreferences(B2LargeUploadWriteFeature.this.session.getHost()).getInteger("b2.upload.largeobject.size.minimum")) {
                    B2GetUploadUrlResponse uploadUrl = ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).getUploadUrl(B2LargeUploadWriteFeature.this.fileid.getVersionId(B2LargeUploadWriteFeature.this.containerService.getContainer(this.file), (ListProgressListener)new DisabledListProgressListener()));
                    Checksum checksum = this.overall.getChecksum();
                    B2FileResponse response = ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).uploadFile(uploadUrl, B2LargeUploadWriteFeature.this.containerService.getKey(this.file), (HttpEntity)new ByteArrayEntity(content, off, len), checksum.algorithm == HashAlgorithm.sha1 ? checksum.hash : "do_not_verify", this.overall.getMime(), fileinfo);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Upload finished for %s with response %s", this.file, response));
                    }
                    B2LargeUploadWriteFeature.this.fileid.cache(this.file, response.getFileId());
                    this.finishLargeFileResponse.set((BaseB2Response)response);
                    this.close.set(true);
                } else {
                    if (0 == this.partNumber) {
                        this.startLargeFileResponse.set(((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).startLargeFileUpload(B2LargeUploadWriteFeature.this.fileid.getVersionId(B2LargeUploadWriteFeature.this.containerService.getContainer(this.file), (ListProgressListener)new DisabledListProgressListener()), B2LargeUploadWriteFeature.this.containerService.getKey(this.file), this.overall.getMime(), fileinfo));
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Multipart upload started for %s with ID %s", this.file, this.startLargeFileResponse.get().getFileId()));
                        }
                    }
                    final int segment = ++this.partNumber;
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Write segment %d for %s", segment, this.file));
                    }
                    this.completed.add((B2UploadPartResponse)new DefaultRetryCallable(B2LargeUploadWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<B2UploadPartResponse>(){

                        public B2UploadPartResponse call() throws BackgroundException {
                            TransferStatus status = new TransferStatus().withLength((long)len);
                            ByteArrayEntity entity = new ByteArrayEntity(content, off, len);
                            Checksum checksum = ChecksumComputeFactory.get((HashAlgorithm)HashAlgorithm.sha1).compute((InputStream)new ByteArrayInputStream(content, off, len), status);
                            try {
                                return ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).uploadLargeFilePart(((B2StartLargeFileResponse)LargeUploadOutputStream.this.startLargeFileResponse.get()).getFileId(), segment, (HttpEntity)entity, checksum.hash);
                            }
                            catch (B2ApiException e) {
                                LargeUploadOutputStream.this.canceled.set(new IOException((Throwable)new B2ExceptionMappingService(B2LargeUploadWriteFeature.this.fileid).map("Upload {0} failed", e, LargeUploadOutputStream.this.file)));
                                throw new B2ExceptionMappingService(B2LargeUploadWriteFeature.this.fileid).map("Upload {0} failed", e, LargeUploadOutputStream.this.file);
                            }
                            catch (IOException e) {
                                LargeUploadOutputStream.this.canceled.set(e);
                                throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, LargeUploadOutputStream.this.file);
                            }
                        }
                    }, (StreamCancelation)this.overall).call());
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (B2ApiException e) {
                throw new IOException(new B2ExceptionMappingService(B2LargeUploadWriteFeature.this.fileid).map("Upload {0} failed", e, this.file));
            }
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn(String.format("Skip double close of stream %s", this));
                    return;
                }
                if (null != this.canceled.get()) {
                    log.warn(String.format("Skip closing with previous failure %s", this.canceled.get()));
                    return;
                }
                if (this.completed.isEmpty()) {
                    this.write(new byte[0]);
                } else {
                    this.completed.sort(new Comparator<B2UploadPartResponse>(){

                        @Override
                        public int compare(B2UploadPartResponse o1, B2UploadPartResponse o2) {
                            return o1.getPartNumber().compareTo(o2.getPartNumber());
                        }
                    });
                    ArrayList<String> checksums = new ArrayList<String>();
                    for (B2UploadPartResponse part : this.completed) {
                        checksums.add(part.getContentSha1());
                    }
                    B2FinishLargeFileResponse response = ((B2ApiClient)B2LargeUploadWriteFeature.this.session.getClient()).finishLargeFileUpload(this.startLargeFileResponse.get().getFileId(), checksums.toArray(new String[checksums.size()]));
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Finished large file upload %s with %d parts", this.file, this.completed.size()));
                    }
                    B2LargeUploadWriteFeature.this.fileid.cache(this.file, response.getFileId());
                    this.finishLargeFileResponse.set((BaseB2Response)response);
                }
            }
            catch (B2ApiException e) {
                throw new IOException(new B2ExceptionMappingService(B2LargeUploadWriteFeature.this.fileid).map("Upload {0} failed", e, this.file));
            }
            finally {
                this.close.set(true);
            }
        }

        public BaseB2Response getFinishLargeFileResponse() {
            return this.finishLargeFileResponse.get();
        }
    }
}

