/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.BytecountStreamListener;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2LargeUploadPartService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpUploadFeature;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.io.StreamProgress;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.SegmentRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2FinishLargeFileResponse;
import synapticloop.b2.response.B2UploadPartResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2LargeUploadService
extends HttpUploadFeature<BaseB2Response, MessageDigest> {
    private static final Logger log = LogManager.getLogger(B2LargeUploadService.class);
    public static final int MAXIMUM_UPLOAD_PARTS = 10000;
    public static final String X_BZ_INFO_LARGE_FILE_SHA1 = "large_file_sha1";
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;
    private final Long partSize;
    private final Integer concurrency;
    private Write<BaseB2Response> writer;

    public B2LargeUploadService(B2Session session, B2VersionIdProvider fileid, Write<BaseB2Response> writer) {
        this(session, fileid, writer, new HostPreferences(session.getHost()).getLong("b2.upload.largeobject.size"), new HostPreferences(session.getHost()).getInteger("b2.upload.largeobject.concurrency"));
    }

    public B2LargeUploadService(B2Session session, B2VersionIdProvider fileid, Write<BaseB2Response> writer, Long partSize, Integer concurrency) {
        super(writer);
        this.session = session;
        this.fileid = fileid;
        this.writer = writer;
        this.partSize = partSize;
        this.concurrency = concurrency;
    }

    public BaseB2Response upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ThreadPool pool = ThreadPoolFactory.get((String)"largeupload", (int)this.concurrency);
        try {
            String fileId;
            ArrayList<B2UploadPartResponse> completed = new ArrayList<B2UploadPartResponse>();
            HashMap<String, String> fileinfo = new HashMap<String, String>(status.getMetadata());
            Checksum checksum = status.getChecksum();
            if (Checksum.NONE != checksum) {
                switch (checksum.algorithm) {
                    case sha1: {
                        fileinfo.put(X_BZ_INFO_LARGE_FILE_SHA1, status.getChecksum().hash);
                    }
                }
            }
            if (null != status.getTimestamp()) {
                fileinfo.put("src_last_modified_millis", String.valueOf(status.getTimestamp()));
            }
            if (status.isAppend()) {
                B2LargeUploadPartService partService = new B2LargeUploadPartService(this.session, this.fileid);
                List<B2FileInfoResponse> uploads = partService.find(file);
                if (uploads.isEmpty()) {
                    fileId = ((B2ApiClient)this.session.getClient()).startLargeFileUpload(this.fileid.getVersionId(this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()), this.containerService.getKey(file), status.getMime(), fileinfo).getFileId();
                } else {
                    fileId = uploads.iterator().next().getFileId();
                    completed.addAll(partService.list(fileId));
                }
            } else {
                fileId = ((B2ApiClient)this.session.getClient()).startLargeFileUpload(this.fileid.getVersionId(this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()), this.containerService.getKey(file), status.getMime(), fileinfo).getFileId();
            }
            long size = status.getLength() + status.getOffset();
            ArrayList<Future<B2UploadPartResponse>> parts = new ArrayList<Future<B2UploadPartResponse>>();
            long remaining = status.getLength();
            long offset = 0L;
            int partNumber = 1;
            while (remaining > 0L) {
                boolean bl = false;
                if (status.isAppend()) {
                    if (log.isInfoEnabled()) {
                        log.info(String.format("Determine if part number %d can be skipped", partNumber));
                    }
                    for (B2UploadPartResponse c : completed) {
                        if (!c.getPartNumber().equals(partNumber)) continue;
                        if (log.isInfoEnabled()) {
                            log.info(String.format("Skip completed part number %d", partNumber));
                        }
                        bl = true;
                        offset += c.getContentLength().longValue();
                        break;
                    }
                }
                if (!bl) {
                    long length = Math.min(Math.max(size / 10000L, this.partSize), remaining);
                    parts.add(this.submit(pool, file, local, throttle, listener, status, fileId, partNumber, offset, length, callback));
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Part %s submitted with size %d and offset %d", partNumber, length, offset));
                    }
                    remaining -= length;
                    offset += length;
                }
                ++partNumber;
            }
            try {
                for (Future future : parts) {
                    completed.add((B2UploadPartResponse)Uninterruptibles.getUninterruptibly((Future)future));
                }
            }
            catch (ExecutionException e) {
                log.warn(String.format("Part upload failed with execution failure %s", e.getMessage()));
                Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
            }
            completed.sort(new Comparator<B2UploadPartResponse>(){

                @Override
                public int compare(B2UploadPartResponse o1, B2UploadPartResponse o2) {
                    return o1.getPartNumber().compareTo(o2.getPartNumber());
                }
            });
            ArrayList<String> checksums = new ArrayList<String>();
            for (B2UploadPartResponse part : completed) {
                checksums.add(part.getContentSha1());
            }
            B2FinishLargeFileResponse b2FinishLargeFileResponse = ((B2ApiClient)this.session.getClient()).finishLargeFileUpload(fileId, checksums.toArray(new String[checksums.size()]));
            if (log.isInfoEnabled()) {
                log.info(String.format("Finished large file upload %s with %d parts", file, completed.size()));
            }
            this.fileid.cache(file, b2FinishLargeFileResponse.getFileId());
            status.withResponse(new B2AttributesFinderFeature(this.session, this.fileid).toAttributes(b2FinishLargeFileResponse)).setComplete();
            B2FinishLargeFileResponse b2FinishLargeFileResponse2 = b2FinishLargeFileResponse;
            return b2FinishLargeFileResponse2;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.fileid).map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
        finally {
            pool.shutdown(false);
        }
    }

    private Future<B2UploadPartResponse> submit(ThreadPool pool, final Path file, final Local local, final BandwidthThrottle throttle, StreamListener listener, final TransferStatus overall, final String fileId, final int partNumber, final Long offset, final Long length, final ConnectionCallback callback) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, file, offset, length));
        }
        final BytecountStreamListener counter = new BytecountStreamListener(listener);
        return pool.execute((Callable)new SegmentRetryCallable(this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<B2UploadPartResponse>(){

            public B2UploadPartResponse call() throws BackgroundException {
                overall.validate();
                TransferStatus status = new TransferStatus().withLength(length.longValue()).withOffset(offset.longValue());
                HashMap<String, String> requestParameters = new HashMap<String, String>();
                requestParameters.put("fileId", fileId);
                status.setParameters(requestParameters);
                status.setHeader(overall.getHeader());
                status.setChecksum(B2LargeUploadService.this.writer.checksum(file, status).compute(local.getInputStream(), status));
                status.setSegment(true);
                status.setPart(Integer.valueOf(partNumber));
                return (B2UploadPartResponse)B2LargeUploadService.super.upload(file, local, throttle, (StreamListener)counter, status, (StreamCancelation)overall, (StreamProgress)status, callback);
            }
        }, (StreamCancelation)overall, counter));
    }

    public Upload<BaseB2Response> withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return super.withWriter(writer);
    }
}

