/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2BucketTypeFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2TouchFeature;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.BucketType;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2DirectoryFeature
implements Directory<BaseB2Response> {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;
    private Write<BaseB2Response> writer;

    public B2DirectoryFeature(B2Session session, B2VersionIdProvider fileid) {
        this(session, fileid, new B2WriteFeature(session, fileid));
    }

    public B2DirectoryFeature(B2Session session, B2VersionIdProvider fileid, B2WriteFeature writer) {
        this.session = session;
        this.fileid = fileid;
        this.writer = writer;
    }

    public Path mkdir(Path folder, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(folder)) {
                B2BucketResponse response = ((B2ApiClient)this.session.getClient()).createBucket(this.containerService.getContainer(folder).getName(), null == status.getRegion() ? BucketType.valueOf((String)new B2BucketTypeFeature(this.session, this.fileid).getDefault().getIdentifier()) : BucketType.valueOf((String)status.getRegion()));
                EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
                type.add(AbstractPath.Type.volume);
                return folder.withType(type).withAttributes(new B2AttributesFinderFeature(this.session, this.fileid).toAttributes(response));
            }
            EnumSet<AbstractPath.Type> type = EnumSet.copyOf(folder.getType());
            type.add(AbstractPath.Type.placeholder);
            return new B2TouchFeature(this.session, this.fileid).touch(folder.withType(type), status.withMime("application/octet-stream").withChecksum(this.writer.checksum(folder, status).compute((InputStream)new NullInputStream(0L), status)));
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.fileid).map("Cannot create folder {0}", e, folder);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        if (workdir.isRoot() && StringUtils.isNotBlank((CharSequence)name)) {
            if (StringUtils.startsWith((CharSequence)name, (CharSequence)"b2-")) {
                return false;
            }
            if (StringUtils.length((CharSequence)name) > 50) {
                return false;
            }
            if (StringUtils.length((CharSequence)name) < 6) {
                return false;
            }
            return StringUtils.isAlphanumeric((CharSequence)RegExUtils.removeAll((String)name, (String)"-"));
        }
        return true;
    }

    public B2DirectoryFeature withWriter(Write<BaseB2Response> writer) {
        this.writer = writer;
        return this;
    }
}

