/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2LargeUploadPartService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2DeleteFeature
implements Delete {
    private static final Logger log = LogManager.getLogger(B2DeleteFeature.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;

    public B2DeleteFeature(B2Session session, B2VersionIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            if (this.containerService.isContainer(file)) continue;
            callback.delete(file);
            if (file.getType().contains(AbstractPath.Type.upload)) {
                new B2LargeUploadPartService(this.session, this.fileid).delete(file.attributes().getVersionId());
                continue;
            }
            if (file.isDirectory()) {
                String placeholder;
                try {
                    placeholder = this.fileid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener());
                }
                catch (NotfoundException e) {
                    log.warn(String.format("Ignore failure %s deleting placeholder file for %s", new Object[]{e, file}));
                    continue;
                }
                try {
                    ((B2ApiClient)this.session.getClient()).deleteFileVersion(this.containerService.getKey(file), placeholder);
                }
                catch (B2ApiException e) {
                    log.warn(String.format("Ignore failure %s deleting placeholder file for %s", e.getMessage(), file));
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            } else if (file.isFile()) {
                try {
                    if (null == file.attributes().getVersionId()) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Add hide marker %s of %s", file.attributes().getVersionId(), file));
                        }
                        ((B2ApiClient)this.session.getClient()).hideFile(this.fileid.getVersionId(this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()), this.containerService.getKey(file));
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Delete version %s of %s", file.attributes().getVersionId(), file));
                        }
                        ((B2ApiClient)this.session.getClient()).deleteFileVersion(this.containerService.getKey(file), file.attributes().getVersionId());
                    }
                }
                catch (B2ApiException e) {
                    throw new B2ExceptionMappingService(this.fileid).map("Cannot delete {0}", e, file);
                }
                catch (IOException e) {
                    throw new DefaultIOExceptionMappingService().map(e);
                }
            }
            this.fileid.cache(file, null);
        }
        for (Path file : files.keySet()) {
            try {
                if (!this.containerService.isContainer(file)) continue;
                callback.delete(file);
                ((B2ApiClient)this.session.getClient()).deleteBucket(this.fileid.getVersionId(file, (ListProgressListener)new DisabledListProgressListener()));
            }
            catch (B2ApiException e) {
                throw new B2ExceptionMappingService(this.fileid).map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
    }
}

