/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileResponse;

public class B2CopyFeature
implements Copy {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;

    public B2CopyFeature(B2Session session, B2VersionIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        try {
            B2FileResponse response = ((B2ApiClient)this.session.getClient()).copyFile(this.fileid.getVersionId(source, (ListProgressListener)new DisabledListProgressListener()), this.fileid.getVersionId(this.containerService.getContainer(target), (ListProgressListener)new DisabledListProgressListener()), this.containerService.getKey(target));
            listener.sent(status.getLength());
            this.fileid.cache(target, response.getFileId());
            return target.withAttributes(new B2AttributesFinderFeature(this.session, this.fileid).toAttributes(response));
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.fileid).map("Cannot copy {0}", e, source);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isSupported(Path source, Path target) {
        if (source.getType().contains(AbstractPath.Type.upload)) {
            return false;
        }
        return this.containerService.getContainer(source).equals((Object)this.containerService.getContainer(target));
    }
}

