/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.shared.DefaultAclFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jets3t.service.acl.Permission;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.BucketType;
import synapticloop.b2.LifecycleRule;
import synapticloop.b2.exception.B2ApiException;

public class B2BucketTypeFeature
extends DefaultAclFeature
implements AclPermission,
Location {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;

    public B2BucketTypeFeature(B2Session session, B2VersionIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Acl getPermission(Path file) {
        if (this.containerService.isContainer(file)) {
            return this.containerService.getContainer(file).attributes().getAcl();
        }
        return Acl.EMPTY;
    }

    public void setPermission(Path file, Acl acl) throws BackgroundException {
        if (this.containerService.isContainer(file)) {
            try {
                BucketType bucketType = this.toBucketType(acl);
                ((B2ApiClient)this.session.getClient()).updateBucket(this.fileid.getVersionId(this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()), bucketType, new LifecycleRule[0]);
            }
            catch (B2ApiException e) {
                throw new B2ExceptionMappingService(this.fileid).map("Cannot change permissions of {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
    }

    protected BucketType toBucketType(Acl acl) {
        return acl.asList().stream().filter(userAndRole -> userAndRole.getUser() instanceof Acl.GroupUser).filter(userAndRole -> userAndRole.getUser().getIdentifier().equals("AllUsers")).findAny().isPresent() ? BucketType.allPublic : BucketType.allPrivate;
    }

    public List<Acl.User> getAvailableAclUsers() {
        return new ArrayList<Acl.GroupUser>(Collections.singletonList(new Acl.GroupUser("AllUsers", false)));
    }

    public List<Acl.Role> getAvailableAclRoles(List<Path> files) {
        return Collections.singletonList(new Acl.Role(Permission.PERMISSION_READ.toString()));
    }

    public Location.Name getDefault() {
        return new B2BucketTypeName(BucketType.valueOf((String)new HostPreferences(this.session.getHost()).getProperty("b2.bucket.acl.default")));
    }

    public Set<Location.Name> getLocations() {
        LinkedHashSet<Location.Name> types = new LinkedHashSet<Location.Name>();
        types.add(new B2BucketTypeName(BucketType.allPrivate));
        types.add(new B2BucketTypeName(BucketType.allPublic));
        return types;
    }

    public Location.Name getLocation(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (container.isRoot()) {
            return unknown;
        }
        return new B2BucketTypeName(BucketType.valueOf((String)new B2AttributesFinderFeature(this.session, this.fileid).find(container).getRegion()));
    }

    public static final class B2BucketTypeName
    extends Location.Name {
        private final String description;

        public B2BucketTypeName(BucketType type) {
            super(type.name());
            switch (type) {
                case allPublic: {
                    this.description = LocaleFactory.localizedString((String)"Public", (String)"B2");
                    break;
                }
                case allPrivate: {
                    this.description = LocaleFactory.localizedString((String)"Private", (String)"B2");
                    break;
                }
                default: {
                    this.description = LocaleFactory.localizedString((String)"Unknown");
                }
            }
        }

        public String toString() {
            return this.description;
        }
    }
}

