/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DefaultPathContainerService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2VersionIdProvider;
import ch.cyberduck.core.b2.B2WriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2BucketResponse;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.B2FileResponse;
import synapticloop.b2.response.B2FinishLargeFileResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2AttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<BaseB2Response> {
    private static final Logger log = LogManager.getLogger(B2AttributesFinderFeature.class);
    private final PathContainerService containerService = new DefaultPathContainerService();
    private final B2Session session;
    private final B2VersionIdProvider fileid;

    public B2AttributesFinderFeature(B2Session session, B2VersionIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (file.isRoot()) {
            return PathAttributes.EMPTY;
        }
        if (file.getType().contains(AbstractPath.Type.upload)) {
            Write.Append append = new B2WriteFeature(this.session, this.fileid).append(file, new TransferStatus());
            if (append.append) {
                return new PathAttributes().withSize(append.size.longValue());
            }
            return PathAttributes.EMPTY;
        }
        if (this.containerService.isContainer(file)) {
            try {
                B2BucketResponse info = ((B2ApiClient)this.session.getClient()).listBucket(file.getName());
                if (null == info) {
                    throw new NotfoundException(file.getAbsolute());
                }
                return this.toAttributes(info);
            }
            catch (B2ApiException e) {
                throw new B2ExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map(e);
            }
        }
        try {
            PathAttributes attr = this.toAttributes(((B2ApiClient)this.session.getClient()).getFileInfo(this.fileid.getVersionId(file, listener)));
            if (attr.isDuplicate() && StringUtils.isBlank((CharSequence)file.attributes().getVersionId())) {
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Latest version of %s is duplicate", file));
                }
                throw new NotfoundException(file.getAbsolute());
            }
            return attr;
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public PathAttributes toAttributes(BaseB2Response response) {
        if (response instanceof B2FileResponse) {
            return this.toAttributes((B2FileResponse)response);
        }
        if (response instanceof B2FileInfoResponse) {
            return this.toAttributes((B2FileInfoResponse)response);
        }
        if (response instanceof B2BucketResponse) {
            return this.toAttributes((B2BucketResponse)response);
        }
        if (response instanceof B2FinishLargeFileResponse) {
            return this.toAttributes((B2FinishLargeFileResponse)response);
        }
        log.error(String.format("Unknown type %s", response));
        return PathAttributes.EMPTY;
    }

    protected PathAttributes toAttributes(B2FileInfoResponse response) {
        PathAttributes attributes = new PathAttributes();
        if (response.getFileInfo().containsKey("large_file_sha1")) {
            attributes.setChecksum(Checksum.parse((String)((String)response.getFileInfo().get("large_file_sha1"))));
        } else {
            attributes.setChecksum(Checksum.parse((String)StringUtils.removeStart((String)StringUtils.lowerCase((String)response.getContentSha1(), (Locale)Locale.ROOT), (String)"unverified:")));
        }
        if (!response.getFileInfo().isEmpty()) {
            attributes.setMetadata(new HashMap(response.getFileInfo()));
        }
        attributes.setVersionId(response.getFileId());
        long timestamp = response.getUploadTimestamp();
        if (response.getFileInfo().containsKey("src_last_modified_millis")) {
            String value = (String)response.getFileInfo().get("src_last_modified_millis");
            try {
                attributes.setModificationDate(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                log.warn(String.format("Failure parsing src_last_modified_millis with value %s", value));
            }
        } else {
            attributes.setModificationDate(timestamp);
        }
        if (response.getAction() != null) {
            switch (response.getAction()) {
                case hide: 
                case start: {
                    attributes.setDuplicate(true);
                    break;
                }
                default: {
                    attributes.setSize(response.getContentLength().longValue());
                }
            }
        }
        return attributes;
    }

    protected PathAttributes toAttributes(B2FileResponse response) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(response.getContentLength());
        if (response.getFileInfo().containsKey("large_file_sha1")) {
            attributes.setChecksum(Checksum.parse((String)((String)response.getFileInfo().get("large_file_sha1"))));
        } else {
            attributes.setChecksum(Checksum.parse((String)StringUtils.removeStart((String)StringUtils.lowerCase((String)response.getContentSha1(), (Locale)Locale.ROOT), (String)"unverified:")));
        }
        if (!response.getFileInfo().isEmpty()) {
            attributes.setMetadata(new HashMap(response.getFileInfo()));
        }
        attributes.setVersionId(response.getFileId());
        long timestamp = response.getUploadTimestamp();
        if (response.getFileInfo().containsKey("src_last_modified_millis")) {
            String value = (String)response.getFileInfo().get("src_last_modified_millis");
            try {
                attributes.setModificationDate(Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                log.warn(String.format("Failure parsing src_last_modified_millis with value %s", value));
            }
        } else {
            attributes.setModificationDate(timestamp);
        }
        if (response.getAction() != null) {
            switch (response.getAction()) {
                case hide: 
                case start: {
                    attributes.setDuplicate(true);
                    break;
                }
                default: {
                    attributes.setSize(response.getContentLength());
                }
            }
        }
        return attributes;
    }

    protected PathAttributes toAttributes(B2BucketResponse response) {
        PathAttributes attributes = new PathAttributes();
        attributes.setVersionId(response.getBucketId());
        attributes.setRegion(response.getBucketType().name());
        switch (response.getBucketType()) {
            case allPublic: {
                attributes.setAcl(new Acl((Acl.User)new Acl.GroupUser("AllUsers", false), new Acl.Role[]{new Acl.Role("READ")}));
            }
        }
        return attributes;
    }

    protected PathAttributes toAttributes(B2FinishLargeFileResponse response) {
        PathAttributes attributes = new PathAttributes();
        attributes.setSize(response.getContentLength().longValue());
        if (response.getFileInfo().containsKey("large_file_sha1")) {
            attributes.setChecksum(Checksum.parse((String)((String)response.getFileInfo().get("large_file_sha1"))));
        } else {
            attributes.setChecksum(Checksum.parse((String)StringUtils.removeStart((String)StringUtils.lowerCase((String)response.getContentSha1(), (Locale)Locale.ROOT), (String)"unverified:")));
        }
        if (!response.getFileInfo().isEmpty()) {
            attributes.setMetadata(new HashMap(response.getFileInfo()));
        }
        attributes.setVersionId(response.getFileId());
        if (response.getFileInfo().containsKey("src_last_modified_millis")) {
            attributes.setModificationDate(Long.parseLong((String)response.getFileInfo().get("src_last_modified_millis")));
        }
        return attributes;
    }
}

