/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features.sharepoint;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractListService;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;
import org.nuxeo.onedrive.client.Sites;
import org.nuxeo.onedrive.client.types.BaseItem;
import org.nuxeo.onedrive.client.types.SharePointIds;
import org.nuxeo.onedrive.client.types.Site;

public class SitesListService
extends AbstractListService<Site.Metadata> {
    private static final Logger log = LogManager.getLogger(SitesListService.class);
    private final AbstractSharepointSession session;

    public SitesListService(AbstractSharepointSession session, GraphFileIdProvider fileid) {
        super(fileid);
        this.session = session;
    }

    @Override
    protected Iterator<Site.Metadata> getIterator(Path directory) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return sites for %s", directory));
        }
        ODataQuery query = new ODataQuery().select(new QueryStringCommaParameter[]{BaseItem.Property.Id, BaseItem.Property.Name, BaseItem.Property.WebUrl, Site.Property.DisplayName, Site.Property.Root, Site.Property.SharepointIds});
        if (!this.session.isSingleSite() && directory.getParent().isRoot()) {
            return Sites.getSites((OneDriveAPI)((OneDriveAPI)this.session.getClient()), (ODataQuery)query.set("search", "*"));
        }
        return Sites.getSites((Site)this.session.getSite(directory.getParent()), (ODataQuery)query);
    }

    @Override
    protected boolean isFiltering(Path directory) {
        return !this.session.isSingleSite() && directory.getParent().isRoot();
    }

    @Override
    protected boolean filter(Site.Metadata metadata) {
        if (metadata.getRoot() == null) {
            return false;
        }
        SharePointIds ids = metadata.getSharepointIds();
        if (ids != null) {
            if (SitesListService.isInvalid(ids.getSiteId())) {
                return false;
            }
            if (SitesListService.isInvalid(ids.getWebId())) {
                return false;
            }
        } else {
            String[] split = StringUtils.split((String)metadata.getId(), (char)',');
            if (split.length != 3) {
                return false;
            }
            if (SitesListService.isInvalid(split[1])) {
                return false;
            }
            if (SitesListService.isInvalid(split[2])) {
                return false;
            }
        }
        return true;
    }

    private static boolean isInvalid(String input) {
        if (input == null || input.length() == 0) {
            return false;
        }
        try {
            UUID uuid = UUID.fromString(input);
            return SharepointID.Invalid.uuid.equals(uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }

    @Override
    protected Path toPath(Site.Metadata metadata, Path directory) {
        PathAttributes attributes = new PathAttributes();
        attributes.setFileId(metadata.getId());
        attributes.setDisplayname(metadata.getDisplayName());
        attributes.setLink(new DescriptiveUrl(URI.create(metadata.getWebUrl())));
        return new Path(directory, metadata.getName(), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
    }

    @Override
    protected void postList(AttributedList<Path> list) {
        HashMap<String, Set> duplicates = new HashMap<String, Set>();
        for (int i = 0; i < list.size(); ++i) {
            final Path file = (Path)list.get(i);
            AttributedList result = list.filter((Filter)new Filter<Path>(){

                public boolean accept(Path test) {
                    return file != test && file.getName().equals(test.getName());
                }

                public Pattern toPattern() {
                    return null;
                }
            });
            if (result.size() <= 0) continue;
            Set set = duplicates.getOrDefault(file.getName(), new HashSet());
            set.add(i);
            duplicates.put(file.getName(), set);
        }
        for (Set set : duplicates.values()) {
            for (Integer i : set) {
                Path file = (Path)list.get(i.intValue());
                URI webLink = URI.create(file.attributes().getLink().getUrl());
                String[] path = webLink.getPath().split(String.valueOf('/'));
                String suffix = path[path.length - 2];
                Path rename = new Path(file.getParent(), String.format("%s (%s)", file.getName(), suffix), file.getType(), file.attributes());
                list.set(i.intValue(), (Referenceable)rename);
            }
        }
    }

    static enum SharepointID {
        Invalid(0L, 0L);

        private final UUID uuid;

        private SharepointID(long mostSigBits, long leastSigBits) {
            this.uuid = new UUID(mostSigBits, leastSigBits);
        }

        UUID getUuid() {
            return this.uuid;
        }
    }
}

