/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features.sharepoint;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractDriveListService;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.Drives;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.Site;

public class SiteDrivesListService
extends AbstractDriveListService {
    private static final Logger log = LogManager.getLogger(SiteDrivesListService.class);
    private final AbstractSharepointSession session;

    public SiteDrivesListService(AbstractSharepointSession session, GraphFileIdProvider fileid) {
        super(fileid);
        this.session = session;
    }

    @Override
    protected Iterator<Drive.Metadata> getIterator(Path directory) throws BackgroundException {
        Site site = this.session.getSite(directory.getParent());
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return drives for site %s", site));
        }
        return Drives.getDrives((Site)site);
    }
}

