/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features.sharepoint;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.SharepointSiteSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import java.io.IOException;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.types.Site;

public class SharepointSiteFileIdProvider
extends GraphFileIdProvider {
    private final SharepointSiteSession session;

    public SharepointSiteFileIdProvider(SharepointSiteSession session) {
        super(session);
        this.session = session;
    }

    private Site.Metadata getSite(Path file) throws IOException {
        Site hostSite = Site.byHostname((OneDriveAPI)((OneDriveAPI)this.session.getClient()), (String)this.session.getHost().getHostname());
        if (file.isRoot()) {
            return hostSite.getMetadata(null);
        }
        return Site.byPath((Site)hostSite, (String)file.getAbsolute()).getMetadata(null);
    }

    @Override
    public String getFileId(Path file, ListProgressListener listener) throws BackgroundException {
        if (this.session.isHome(file)) {
            Site.Metadata site;
            try {
                site = this.getSite(file);
            }
            catch (IOException exception) {
                throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)exception, file);
            }
            return site.getId();
        }
        return super.getFileId(file, listener);
    }
}

