/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features.sharepoint;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.onedrive.AbstractListService;
import ch.cyberduck.core.onedrive.SharepointSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.Groups;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.types.GroupItem;
import org.nuxeo.onedrive.client.types.User;

public class GroupListService
extends AbstractListService<GroupItem.Metadata> {
    private static final Logger log = LogManager.getLogger(GroupListService.class);
    private final SharepointSession session;

    public GroupListService(SharepointSession session, GraphFileIdProvider fileid) {
        super(fileid);
        this.session = session;
    }

    @Override
    protected Iterator<GroupItem.Metadata> getIterator(Path directory) {
        User user = User.getCurrent((OneDriveAPI)((OneDriveAPI)this.session.getClient()));
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return groups for user %s", user));
        }
        return Groups.getMemberOfGroups((User)user);
    }

    @Override
    protected Path toPath(GroupItem.Metadata metadata, Path directory) {
        PathAttributes attributes = new PathAttributes();
        attributes.setFileId(metadata.getId());
        return new Path(directory, metadata.getDisplayName(), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory, AbstractPath.Type.placeholder), attributes);
    }
}

