/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features.sharepoint;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractDriveListService;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.Drives;
import org.nuxeo.onedrive.client.types.DirectoryObject;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.GroupItem;

public class GroupDrivesListService
extends AbstractDriveListService {
    private static final Logger log = LogManager.getLogger(GroupDrivesListService.class);
    private final AbstractSharepointSession session;

    public GroupDrivesListService(AbstractSharepointSession session, GraphFileIdProvider fileid) {
        super(fileid);
        this.session = session;
    }

    @Override
    protected Iterator<Drive.Metadata> getIterator(Path directory) throws BackgroundException {
        GroupItem group = this.session.getGroup(directory);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return drives for group %s", group));
        }
        return Drives.getDrives((DirectoryObject)group);
    }
}

