/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.io.MemorySegementingOutputStream;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.io.StreamCancelation;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.onedrive.features.GraphTouchFeature;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.threading.BackgroundExceptionCallable;
import ch.cyberduck.core.threading.DefaultRetryCallable;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveJsonObject;
import org.nuxeo.onedrive.client.UploadSession;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphWriteFeature
implements Write<DriveItem.Metadata> {
    private static final Logger log = LogManager.getLogger(GraphWriteFeature.class);
    private final GraphSession session;
    private final GraphFileIdProvider fileid;

    public GraphWriteFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public StatusOutputStream<DriveItem.Metadata> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            if (status.getLength() == -1L) {
                throw new UnsupportedException("Content-Range with unknown file size is not supported");
            }
            DriveItem folder = this.session.getItem(file.getParent());
            DriveItem item = status.isExists() ? this.session.getItem(file) : new DriveItem(folder, URIEncoder.encode((String)file.getName()));
            UploadSession upload = Files.createUploadSession((DriveItem)item);
            final ChunkedOutputStream proxy = new ChunkedOutputStream(upload, file, status);
            int partsize = new HostPreferences(this.session.getHost()).getInteger("onedrive.upload.multipart.partsize.minimum") * new HostPreferences(this.session.getHost()).getInteger("onedrive.upload.multipart.partsize.factor");
            return new HttpResponseOutputStream<DriveItem.Metadata>((OutputStream)new MemorySegementingOutputStream((OutputStream)proxy, Integer.valueOf(partsize)), (AttributesAdapter)new GraphAttributesFinderFeature(this.session, this.fileid), status){

                public DriveItem.Metadata getStatus() {
                    return proxy.getStatus();
                }
            };
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Upload {0} failed", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
        }
    }

    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return new Write.Append(false).withStatus(status);
    }

    private final class ChunkedOutputStream
    extends OutputStream {
        private final UploadSession upload;
        private final Path file;
        private final TransferStatus overall;
        private final AtomicBoolean close = new AtomicBoolean();
        private final AtomicReference<DriveItem.Metadata> response = new AtomicReference();
        private Long offset = 0L;
        private final Long length;

        public ChunkedOutputStream(UploadSession upload, Path file, TransferStatus status) {
            this.upload = upload;
            this.file = file;
            this.overall = status;
            this.length = status.getOffset() + status.getLength();
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException(new UnsupportedOperationException());
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            final byte[] content = Arrays.copyOfRange(b, off, len);
            HttpRange range = HttpRange.byLength((long)this.offset, (long)content.length);
            final String header = String.format("%d-%d/%d", range.getStart(), range.getEnd(), this.length);
            try {
                new DefaultRetryCallable(GraphWriteFeature.this.session.getHost(), (BackgroundExceptionCallable)new BackgroundExceptionCallable<Void>(){

                    public Void call() throws BackgroundException {
                        try {
                            OneDriveJsonObject reply = ChunkedOutputStream.this.upload.uploadFragment(header, content);
                            if (reply instanceof DriveItem.Metadata) {
                                if (log.isInfoEnabled()) {
                                    log.info(String.format("Completed upload for %s", ChunkedOutputStream.this.file));
                                }
                                String id = GraphWriteFeature.this.session.getFileId((DriveItem.Metadata)reply);
                                GraphWriteFeature.this.fileid.cache(ChunkedOutputStream.this.file, id);
                                ChunkedOutputStream.this.response.set((DriveItem.Metadata)reply);
                            } else {
                                log.debug(String.format("Uploaded fragment %s for file %s", header, ChunkedOutputStream.this.file));
                            }
                        }
                        catch (OneDriveAPIException e) {
                            throw new GraphExceptionMappingService(GraphWriteFeature.this.fileid).map("Upload {0} failed", e, ChunkedOutputStream.this.file);
                        }
                        catch (IOException e) {
                            throw new DefaultIOExceptionMappingService().map("Upload {0} failed", (Throwable)e, ChunkedOutputStream.this.file);
                        }
                        return null;
                    }
                }, (StreamCancelation)this.overall).call();
            }
            catch (BackgroundException e) {
                throw new IOException(e.getMessage(), e);
            }
            this.offset = this.offset + (long)content.length;
        }

        @Override
        public void close() throws IOException {
            try {
                if (this.close.get()) {
                    log.warn(String.format("Skip double close of stream %s", this));
                    return;
                }
                if (0L == this.offset) {
                    log.warn(String.format("Abort upload session %s with no completed parts", this.upload));
                    this.upload.cancelUpload();
                    new GraphTouchFeature(GraphWriteFeature.this.session, GraphWriteFeature.this.fileid).touch(this.file, this.overall);
                }
            }
            catch (BackgroundException e) {
                throw new IOException(e);
            }
            finally {
                this.close.set(true);
            }
        }

        public DriveItem.Metadata getStatus() {
            return this.response.get();
        }
    }
}

