/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.DriveItemVersion;

public class GraphVersioningFeature
implements Versioning {
    private final GraphSession session;
    private final GraphFileIdProvider fileid;
    private final GraphAttributesFinderFeature attributes;

    public GraphVersioningFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
        this.attributes = new GraphAttributesFinderFeature(session, fileid);
    }

    public VersioningConfiguration getConfiguration(Path container) {
        return new VersioningConfiguration(true);
    }

    public void setConfiguration(Path container, PasswordCallback prompt, VersioningConfiguration configuration) throws BackgroundException {
        throw new UnsupportedException();
    }

    public void revert(Path file) throws BackgroundException {
        DriveItem item = this.session.getItem(file);
        try {
            Files.restore((DriveItem)item, (String)file.attributes().getVersionId());
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Cannot revert file", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot revert file", (Throwable)e, file);
        }
    }

    public boolean isRevertable(Path file) {
        return true;
    }

    public AttributedList<Path> list(Path file, ListProgressListener listener) throws BackgroundException {
        AttributedList versions = new AttributedList();
        DriveItem item = this.session.getItem(file);
        try {
            DriveItem.Metadata parentMetadata = this.session.getMetadata(item, null);
            List items = Files.versions((DriveItem)item);
            for (DriveItemVersion version : items.stream().skip(1L).collect(Collectors.toList())) {
                versions.add((Referenceable)new Path(file).withAttributes(this.attributes.toAttributes(parentMetadata, version)));
            }
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
        return versions;
    }
}

