/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphTouchFeature
implements Touch<DriveItem.Metadata> {
    private final GraphSession session;
    private final GraphFileIdProvider fileid;

    public GraphTouchFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        try {
            DriveItem folder = this.session.getItem(file.getParent());
            DriveItem.Metadata metadata = Files.createFile((DriveItem)folder, (String)URIEncoder.encode((String)file.getName()), (String)(StringUtils.isNotBlank((CharSequence)status.getMime()) ? status.getMime() : "application/octet-stream"));
            PathAttributes attr = new GraphAttributesFinderFeature(this.session, this.fileid).toAttributes(metadata);
            this.fileid.cache(file, attr.getFileId());
            return file.withAttributes(attr);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Cannot create {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create {0}", (Throwable)e, file);
        }
    }

    public boolean isSupported(Path workdir, String filename) {
        return this.session.isAccessible(workdir);
    }

    public Touch<DriveItem.Metadata> withWriter(Write writer) {
        return this;
    }
}

