/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.shared.DefaultTimestampFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.PatchOperation;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.Facet;
import org.nuxeo.onedrive.client.types.FileSystemInfo;

public class GraphTimestampFeature
extends DefaultTimestampFeature {
    private final GraphSession session;
    private final GraphFileIdProvider fileid;

    public GraphTimestampFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void setTimestamp(Path file, TransferStatus status) throws BackgroundException {
        PatchOperation patchOperation = new PatchOperation();
        FileSystemInfo info = new FileSystemInfo();
        info.setLastModifiedDateTime(Instant.ofEpochMilli(status.getTimestamp()).atOffset(ZoneOffset.UTC));
        patchOperation.facet("fileSystemInfo", (Facet)info);
        DriveItem item = this.session.getItem(file);
        try {
            Files.patch((DriveItem)item, (PatchOperation)patchOperation);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to write attributes of {0}", (Throwable)e, file);
        }
    }
}

