/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.shared.DefaultHomeFinderService;
import java.io.IOException;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.Quota;

public class GraphQuotaFeature
implements ch.cyberduck.core.features.Quota {
    private final GraphSession session;
    private final GraphFileIdProvider fileid;

    public GraphQuotaFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Quota.Space get() throws BackgroundException {
        Long used;
        Drive.Metadata metadata;
        Path home = new DefaultHomeFinderService((Session)this.session).find();
        if (!this.session.isAccessible(home)) {
            return unknown;
        }
        try {
            DriveItem item = this.session.getItem(home, true);
            metadata = item.getDrive().getMetadata(new ODataQuery().select((QueryStringCommaParameter)Drive.Property.Quota));
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, home);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, home);
        }
        Quota quota = metadata.getQuota();
        if (quota != null && (used = quota.getUsed()) != null) {
            Long remaining = quota.getRemaining();
            if (remaining != null && (used != 0L || remaining != 0L)) {
                return new Quota.Space(used, remaining);
            }
            Long total = quota.getTotal();
            if (total != null && (used != 0L || total != 0L)) {
                return new Quota.Space(used, Long.valueOf(total - used));
            }
        }
        return unknown;
    }
}

