/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.CachingFileIdProvider;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.onedrive.GraphSession;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GraphFileIdProvider
extends CachingFileIdProvider
implements FileIdProvider {
    private static final Logger log = LogManager.getLogger(GraphFileIdProvider.class);
    private final GraphSession session;

    public GraphFileIdProvider(GraphSession session) {
        super(session.getCaseSensitivity());
        this.session = session;
    }

    public String getFileId(Path file, ListProgressListener listener) throws BackgroundException {
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
            return file.attributes().getFileId();
        }
        String cached = super.getFileId(file, listener);
        if (cached != null) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Return cached fileid %s for file %s", cached, file));
            }
            return cached;
        }
        AttributedList list = this.session._getFeature(ListService.class).list(file.getParent(), listener);
        Path found = (Path)list.find((Predicate)((Object)new SymlinkUnawarePathPredicate(file)));
        if (null == found) {
            throw new NotfoundException(file.getAbsolute());
        }
        return this.cache(file, found.attributes().getFileId());
    }

    private static final class SymlinkUnawarePathPredicate
    extends SimplePathPredicate {
        public SymlinkUnawarePathPredicate(Path file) {
            super(file.isFile() ? AbstractPath.Type.file : AbstractPath.Type.directory, file.getAbsolute());
        }

        public boolean test(Path test) {
            return this.equals((Object)new SymlinkUnawarePathPredicate(test));
        }
    }
}

