/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphDirectoryFeature
implements Directory<Void> {
    private final GraphSession session;
    private final GraphAttributesFinderFeature attributes;
    private final GraphFileIdProvider fileid;

    public GraphDirectoryFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.attributes = new GraphAttributesFinderFeature(session, fileid);
        this.fileid = fileid;
    }

    public Path mkdir(Path directory, TransferStatus status) throws BackgroundException {
        DriveItem folder = this.session.getItem(directory.getParent());
        try {
            DriveItem.Metadata metadata = Files.createFolder((DriveItem)folder, (String)directory.getName());
            PathAttributes attr = this.attributes.toAttributes(metadata);
            this.fileid.cache(directory, attr.getFileId());
            return directory.withAttributes(attr);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Cannot create folder {0}", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot create folder {0}", (Throwable)e, directory);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return this.session.isAccessible(workdir);
    }

    public Directory<Void> withWriter(Write writer) {
        return this;
    }
}

