/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Map;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphDeleteFeature
implements Delete {
    private final GraphSession session;
    private final GraphFileIdProvider fileid;

    public GraphDeleteFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            callback.delete(file);
            try {
                DriveItem item = this.session.getItem(file);
                Files.delete((DriveItem)item);
                this.fileid.cache(file, null);
            }
            catch (OneDriveAPIException e) {
                throw new GraphExceptionMappingService(this.fileid).map("Cannot delete {0}", e, file);
            }
            catch (IOException e) {
                throw new DefaultIOExceptionMappingService().map("Cannot delete {0}", (Throwable)e, file);
            }
        }
    }

    public boolean isSupported(Path file) {
        return this.session.isAccessible(file, false);
    }

    public boolean isRecursive() {
        return true;
    }
}

