/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphDeleteFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.CopyOperation;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphCopyFeature
implements Copy {
    private static final Logger logger = LogManager.getLogger(GraphCopyFeature.class);
    private final GraphSession session;
    private final GraphAttributesFinderFeature attributes;
    private final GraphFileIdProvider fileid;

    public GraphCopyFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.attributes = new GraphAttributesFinderFeature(session, fileid);
        this.fileid = fileid;
    }

    public Path copy(Path file, Path target, TransferStatus status, ConnectionCallback callback, StreamListener listener) throws BackgroundException {
        CopyOperation copyOperation = new CopyOperation();
        if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)target.getName())) {
            copyOperation.rename(target.getName());
        }
        if (status.isExists()) {
            if (logger.isWarnEnabled()) {
                logger.warn(String.format("Delete file %s to be replaced with %s", target, file));
            }
            new GraphDeleteFeature(this.session, this.fileid).delete(Collections.singletonMap(target, status), (PasswordCallback)callback, (Delete.Callback)new Delete.DisabledCallback());
        }
        DriveItem targetItem = this.session.getItem(target.getParent());
        copyOperation.copy(targetItem);
        DriveItem item = this.session.getItem(file);
        try {
            Files.copy((DriveItem)item, (CopyOperation)copyOperation).await(statusObject -> logger.info(String.format("Copy Progress Operation %s progress %f status %s", statusObject.getOperation(), Float.valueOf(statusObject.getPercentage()), statusObject.getStatus())));
            listener.sent(status.getLength());
            target.attributes().setFileId(null);
            PathAttributes attr = this.attributes.find(target);
            this.fileid.cache(target, attr.getFileId());
            return target.withAttributes(attr);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Cannot copy {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot copy {0}", (Throwable)e, file);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (!this.session.isAccessible(target, true)) {
            return false;
        }
        if (!this.session.isAccessible(source, false)) {
            return false;
        }
        if (!this.session.getContainer(source).equals(this.session.getContainer(target))) {
            return false;
        }
        return !source.getType().contains(AbstractPath.Type.shared);
    }
}

