/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesAdapter;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.DriveItemVersion;
import org.nuxeo.onedrive.client.types.FileSystemInfo;
import org.nuxeo.onedrive.client.types.Publication;

public class GraphAttributesFinderFeature
implements AttributesFinder,
AttributesAdapter<DriveItem.Metadata> {
    private static final Logger log = LogManager.getLogger(GraphAttributesFinderFeature.class);
    private final GraphSession session;
    private final GraphFileIdProvider fileid;

    public GraphAttributesFinderFeature(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    static Optional<DescriptiveUrl> getWebUrl(DriveItem.Metadata metadata) {
        DescriptiveUrl url = null;
        try {
            url = new DescriptiveUrl(new URI(metadata.getWebUrl()), DescriptiveUrl.Type.http);
        }
        catch (URISyntaxException e) {
            log.warn(String.format("Cannot create URI of WebURL: %s", metadata.getWebUrl()), (Throwable)e);
        }
        return Optional.ofNullable(url);
    }

    public PathAttributes find(Path file, ListProgressListener listener) throws BackgroundException {
        if (!this.session.isAccessible(file)) {
            return PathAttributes.EMPTY;
        }
        DriveItem item = this.session.getItem(file);
        try {
            return this.toAttributes(this.toMetadata(file, item));
        }
        catch (NotfoundException e) {
            return this.toAttributes(this.toMetadata(file, this.session.getItem(file)));
        }
    }

    private DriveItem.Metadata toMetadata(Path file, DriveItem item) throws BackgroundException {
        try {
            return this.session.getMetadata(item, null);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService(this.fileid).map("Failure to read attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Failure to read attributes of {0}", (Throwable)e, file);
        }
    }

    public PathAttributes toAttributes(DriveItem.Metadata metadata) {
        PathAttributes attributes = new PathAttributes();
        attributes.setETag(metadata.getETag());
        Optional<DescriptiveUrl> webUrl = GraphAttributesFinderFeature.getWebUrl(metadata);
        if (metadata.isPackage()) {
            webUrl.ifPresent(url -> attributes.setSize((long)UrlFileWriterFactory.get().write(url).getBytes(Charset.defaultCharset()).length));
        } else if (null != metadata.getSize()) {
            attributes.setSize(metadata.getSize().longValue());
        }
        this.setId(attributes, this.session.getFileId(metadata));
        webUrl.ifPresent(arg_0 -> ((PathAttributes)attributes).setLink(arg_0));
        FileSystemInfo info = (FileSystemInfo)metadata.getFacet(FileSystemInfo.class);
        if (null != info) {
            if (-1L == info.getLastModifiedDateTime().toInstant().toEpochMilli()) {
                attributes.setModificationDate(metadata.getLastModifiedDateTime().toInstant().toEpochMilli());
            } else {
                attributes.setModificationDate(info.getLastModifiedDateTime().toInstant().toEpochMilli());
            }
            if (-1L == info.getCreatedDateTime().toInstant().toEpochMilli()) {
                attributes.setCreationDate(metadata.getCreatedDateTime().toInstant().toEpochMilli());
            } else {
                attributes.setCreationDate(info.getCreatedDateTime().toInstant().toEpochMilli());
            }
        } else {
            attributes.setModificationDate(metadata.getLastModifiedDateTime().toInstant().toEpochMilli());
            attributes.setCreationDate(metadata.getCreatedDateTime().toInstant().toEpochMilli());
        }
        Publication publication = metadata.getPublication();
        if (null != publication && publication.getLevel() == Publication.State.checkout) {
            attributes.setLockId(publication.getVersionId());
        }
        return attributes;
    }

    public PathAttributes toAttributes(DriveItem.Metadata metadata, DriveItemVersion version) {
        PathAttributes attributes = this.toAttributes(metadata);
        attributes.setVersionId(version.getId());
        attributes.setDuplicate(true);
        attributes.setSize(version.getSize().longValue());
        attributes.setModificationDate(version.getLastModifiedDateTime().toInstant().toEpochMilli());
        return attributes;
    }

    private void setId(PathAttributes attributes, String id) {
        attributes.setFileId(id);
    }
}

