/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointSiteListService;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.onedrive.features.sharepoint.SharepointSiteFileIdProvider;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.util.Deque;
import org.nuxeo.onedrive.client.types.Drive;

public class SharepointSiteSession
extends AbstractSharepointSession {
    public SharepointSiteSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    @Override
    public boolean isSingleSite() {
        return true;
    }

    @Override
    protected Drive findDrive(GraphSession.ContainerItem driveContainer) throws BackgroundException {
        String driveId = this.fileid.getFileId(driveContainer.getContainerPath().get(), (ListProgressListener)new DisabledListProgressListener());
        Path container = driveContainer.getCollectionPath().get().getParent();
        return new Drive(this.getSite(container), driveId);
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SharepointSiteListService(this, this.fileid);
        }
        if (type == GraphFileIdProvider.class) {
            return (T)((Object)new SharepointSiteFileIdProvider(this));
        }
        return super._getFeature(type);
    }

    @Override
    public GraphSession.ContainerItem getContainer(Path file) {
        Deque<Path> pathDeque = this.decompose(file);
        Path lastContainer = null;
        Path lastCollection = null;
        boolean exit = false;
        boolean nextExit = false;
        block8: while (!exit && pathDeque.size() > 0) {
            Path current = pathDeque.pop();
            exit = nextExit;
            switch (current.getName()) {
                case "Drives": {
                    nextExit = true;
                }
                case "Sites": {
                    lastCollection = current;
                    continue block8;
                }
            }
            lastContainer = current;
        }
        return new GraphSession.ContainerItem(lastContainer, lastCollection, exit);
    }
}

