/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointListService;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.util.Deque;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.types.DirectoryObject;
import org.nuxeo.onedrive.client.types.Drive;

public class SharepointSession
extends AbstractSharepointSession {
    private static final Logger log = LogManager.getLogger(SharepointSession.class);

    public SharepointSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    @Override
    public boolean isSingleSite() {
        return false;
    }

    @Override
    protected Drive findDrive(GraphSession.ContainerItem driveContainer) throws BackgroundException {
        String driveId = this.fileid.getFileId(driveContainer.getContainerPath().get(), (ListProgressListener)new DisabledListProgressListener());
        GraphSession.ContainerItem parentContainer = this.getContainer(driveContainer.getContainerPath().get().getParent());
        if (parentContainer.getCollectionPath().map(p -> "Groups".equals(p.getName())).orElse(false).booleanValue()) {
            return new Drive((DirectoryObject)this.getGroup(parentContainer.getContainerPath().get()), driveId);
        }
        if (parentContainer.getContainerPath().map(p -> "Default".equals(p.getName())).orElse(false).booleanValue()) {
            return new Drive(this.getSite(parentContainer.getContainerPath().get()), driveId);
        }
        GraphSession.ContainerItem containerItem = this.getContainer(parentContainer.getContainerPath().get());
        if (containerItem.getCollectionPath().map(p -> "Sites".equals(p.getName())).orElse(false).booleanValue()) {
            return new Drive(this.getSite(containerItem.getContainerPath().get()), driveId);
        }
        return null;
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SharepointListService(this, this.fileid);
        }
        return super._getFeature(type);
    }

    @Override
    public GraphSession.ContainerItem getContainer(Path file) {
        Deque<Path> pathDeque = this.decompose(file);
        Path lastContainer = null;
        Path lastCollection = null;
        boolean exit = false;
        boolean nextExit = false;
        boolean exitEarly = false;
        block10: while (!exit && pathDeque.size() > 0) {
            Path current = pathDeque.pop();
            exit = nextExit;
            nextExit = exitEarly;
            switch (current.getName()) {
                case "Drives": {
                    nextExit = true;
                }
                case "Sites": {
                    lastCollection = current;
                    continue block10;
                }
                case "Groups": {
                    lastCollection = current;
                    exitEarly = true;
                    continue block10;
                }
            }
            lastContainer = current;
        }
        return new GraphSession.ContainerItem(lastContainer, lastCollection, exit);
    }
}

