/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractSharepointListService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.onedrive.features.sharepoint.GroupDrivesListService;
import ch.cyberduck.core.onedrive.features.sharepoint.GroupListService;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.types.Site;

public class SharepointListService
extends AbstractSharepointListService {
    static final Logger log = LogManager.getLogger(SharepointListService.class);
    public static final String DEFAULT_SITE = "Default";
    public static final String DRIVES_CONTAINER = "Drives";
    public static final String GROUPS_CONTAINER = "Groups";
    public static final String SITES_CONTAINER = "Sites";
    public static final Path DEFAULT_NAME = new Path("/Default", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.placeholder, AbstractPath.Type.directory, AbstractPath.Type.symboliclink));
    public static final Path DRIVES_NAME = new Path("/Drives", EnumSet.of(AbstractPath.Type.placeholder, AbstractPath.Type.directory));
    public static final Path GROUPS_NAME = new Path("/Groups", EnumSet.of(AbstractPath.Type.placeholder, AbstractPath.Type.directory));
    public static final Path SITES_NAME = new Path("/Sites", EnumSet.of(AbstractPath.Type.placeholder, AbstractPath.Type.directory));
    private final SharepointSession session;
    private final GraphFileIdProvider fileid;

    public SharepointListService(SharepointSession session, GraphFileIdProvider fileid) {
        super(session, fileid);
        this.session = session;
        this.fileid = fileid;
    }

    private Optional<Path> getDefault(Path directory) {
        try {
            Site site = Site.byId((OneDriveAPI)((OneDriveAPI)this.session.getClient()), (String)"root");
            Site.Metadata metadata = site.getMetadata(null);
            EnumSet type = EnumSet.copyOf(DEFAULT_NAME.getType());
            Path path = new Path(directory, DEFAULT_NAME.getName(), type, new PathAttributes().withFileId(metadata.getId()));
            path.setSymlinkTarget(new Path(SITES_NAME, metadata.getSiteCollection().getHostname(), SITES_NAME.getType(), new PathAttributes().withFileId(metadata.getId())));
            return Optional.of(path);
        }
        catch (IOException ex) {
            log.error("Cannot get default site. Skipping.", (Throwable)ex);
            return Optional.empty();
        }
    }

    @Override
    protected AttributedList<Path> getRoot(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList list = new AttributedList();
        this.getDefault(directory).ifPresent(arg_0 -> ((AttributedList)list).add(arg_0));
        SharepointListService.addDefaultItems((AttributedList<Path>)list);
        listener.chunk(directory, list);
        return list;
    }

    static void addDefaultItems(AttributedList<Path> list) {
        list.add((Referenceable)GROUPS_NAME);
        list.add((Referenceable)SITES_NAME);
    }

    @Override
    protected AttributedList<Path> processList(Path directory, ListProgressListener listener) throws BackgroundException {
        GraphSession.ContainerItem container = this.session.getContainer(directory);
        if (container.isDrive()) {
            return AttributedList.emptyList();
        }
        if (!container.isDefined() && container.getContainerPath().map(p -> DEFAULT_SITE.equals(p.getName())).orElse(false).booleanValue()) {
            return this.addSiteItems(directory, listener);
        }
        if (container.getCollectionPath().map(p -> GROUPS_CONTAINER.equals(p.getName())).orElse(false).booleanValue()) {
            if (!container.isDefined()) {
                return new GroupListService(this.session, this.fileid).list(directory, listener);
            }
            return new GroupDrivesListService(this.session, this.fileid).list(directory, listener);
        }
        return AttributedList.emptyList();
    }
}

