/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.OneDriveListService;
import ch.cyberduck.core.onedrive.features.GraphLockFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.io.IOException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;
import org.nuxeo.onedrive.client.types.BaseItem;
import org.nuxeo.onedrive.client.types.DirectoryObject;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.ItemReference;
import org.nuxeo.onedrive.client.types.User;

public class OneDriveSession
extends GraphSession {
    public static final GraphSession.ContainerItem MYFILES = new GraphSession.ContainerItem(OneDriveListService.MYFILES_NAME, null, true);
    public static final GraphSession.ContainerItem SHAREDFILES = new GraphSession.ContainerItem(null, OneDriveListService.SHARED_NAME, false);

    public OneDriveSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    @Override
    public String getFileId(DriveItem.Metadata metadata) {
        ItemReference parent = metadata.getParentReference();
        if (metadata.getRemoteItem() != null) {
            DriveItem.Metadata remoteMetadata = metadata.getRemoteItem();
            ItemReference remoteParent = remoteMetadata.getParentReference();
            if (parent == null) {
                return String.join((CharSequence)String.valueOf('/'), remoteParent.getDriveId(), remoteParent.getId());
            }
            String remoteItemId = remoteParent.getId();
            if (StringUtils.isBlank((CharSequence)remoteItemId)) {
                remoteItemId = remoteMetadata.getId();
            }
            return String.join((CharSequence)String.valueOf('/'), parent.getDriveId(), metadata.getId(), remoteParent.getDriveId(), remoteItemId);
        }
        return String.join((CharSequence)String.valueOf('/'), parent.getDriveId(), metadata.getId());
    }

    @Override
    public DriveItem.Metadata getMetadata(DriveItem item, ODataQuery query) throws IOException {
        if (query == null) {
            query = new ODataQuery();
        }
        query.select(new QueryStringCommaParameter[]{BaseItem.Property.ParentReference, DriveItem.Property.RemoteItem});
        return super.getMetadata(item, query);
    }

    @Override
    public DriveItem getItem(Path file, boolean resolveLastItem) throws BackgroundException {
        String itemId;
        String driveId;
        if (OneDriveListService.MYFILES_NAME.equals((Object)file)) {
            User.Metadata user = this.getUser();
            if (null == user || user.getCreationType() == null) {
                return new Drive((OneDriveAPI)this.client).getRoot();
            }
            return new Drive((DirectoryObject)user.asDirectoryObject()).getRoot();
        }
        String id = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new NotfoundException(String.format("Version ID for %s is empty", file.getAbsolute()));
        }
        String[] idParts = id.split(String.valueOf('/'));
        if (idParts.length == 2 || !resolveLastItem) {
            driveId = idParts[0];
            itemId = idParts[1];
        } else if (idParts.length == 4) {
            driveId = idParts[2];
            itemId = idParts[3];
        } else {
            throw new NotfoundException(file.getAbsolute());
        }
        Drive drive = new Drive((OneDriveAPI)this.getClient(), driveId);
        return new DriveItem(drive, itemId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAccessible(Path file, boolean container) {
        if (file.isRoot()) {
            return false;
        }
        if (file.attributes().isDuplicate()) {
            return false;
        }
        GraphSession.ContainerItem containerItem = this.getContainer(file);
        if (containerItem.isDrive()) {
            if (container) return true;
            if (containerItem.getContainerPath().map(arg_0 -> ((Path)file).equals(arg_0)).orElse(false) != false) return false;
            return true;
        }
        Optional<Boolean> predicate = containerItem.getCollectionPath().map(arg_0 -> ((Path)file).equals(arg_0));
        if (!container) {
            predicate = predicate.map(o -> {
                boolean bl;
                if (!o.booleanValue()) {
                    if (!containerItem.getCollectionPath().map(arg_0 -> ((Path)file.getParent()).equals(arg_0)).get().booleanValue()) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            });
        }
        if (predicate.orElse(true) != false) return false;
        return true;
    }

    @Override
    public GraphSession.ContainerItem getContainer(Path file) {
        if (new SimplePathPredicate(OneDriveListService.MYFILES_NAME).test(file) || file.isChild(OneDriveListService.MYFILES_NAME)) {
            return MYFILES;
        }
        if (new SimplePathPredicate(OneDriveListService.SHARED_NAME).test(file) || file.isChild(OneDriveListService.SHARED_NAME)) {
            return SHAREDFILES;
        }
        return GraphSession.ContainerItem.EMPTY;
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new OneDriveListService(this, this.fileid);
        }
        if (type == Lock.class && null != this.getUser() && null != this.getUser().getCreationType()) {
            return (T)new GraphLockFeature(this, this.fileid);
        }
        return super._getFeature(type);
    }
}

