/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.GraphItemListService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.onedrive.features.onedrive.SharedWithMeListService;
import java.util.EnumSet;

public class OneDriveListService
implements ListService {
    public static final Path MYFILES_NAME = new Path("/My Files", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.placeholder, AbstractPath.Type.directory));
    public static final Path SHARED_NAME = new Path("/Shared", EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.placeholder, AbstractPath.Type.directory));
    private final GraphSession session;
    private final GraphFileIdProvider fileid;

    public OneDriveListService(GraphSession session, GraphFileIdProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            AttributedList list = new AttributedList();
            list.add((Referenceable)MYFILES_NAME);
            list.add((Referenceable)SHARED_NAME);
            listener.chunk(directory, list);
            return list;
        }
        if (new SimplePathPredicate(SHARED_NAME).test(directory)) {
            return new SharedWithMeListService(this.session, this.fileid).list(directory, listener);
        }
        return new GraphItemListService(this.session, this.fileid).list(directory, listener);
    }
}

