/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.HostParserException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.FileIdProvider;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.onedrive.GraphCommonsHttpRequestExecutor;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphCopyFeature;
import ch.cyberduck.core.onedrive.features.GraphDeleteFeature;
import ch.cyberduck.core.onedrive.features.GraphDirectoryFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.onedrive.features.GraphFindFeature;
import ch.cyberduck.core.onedrive.features.GraphMoveFeature;
import ch.cyberduck.core.onedrive.features.GraphPromptUrlProvider;
import ch.cyberduck.core.onedrive.features.GraphQuotaFeature;
import ch.cyberduck.core.onedrive.features.GraphReadFeature;
import ch.cyberduck.core.onedrive.features.GraphTimestampFeature;
import ch.cyberduck.core.onedrive.features.GraphTouchFeature;
import ch.cyberduck.core.onedrive.features.GraphUrlProvider;
import ch.cyberduck.core.onedrive.features.GraphVersioningFeature;
import ch.cyberduck.core.onedrive.features.GraphWriteFeature;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.shared.BufferWriteFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;
import org.nuxeo.onedrive.client.Users;
import org.nuxeo.onedrive.client.types.BaseItem;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.User;

public abstract class GraphSession
extends HttpSession<OneDriveAPI> {
    private static final Logger log = LogManager.getLogger(GraphSession.class);
    private static final String API_VERSION = "v1.0";
    protected final GraphFileIdProvider fileid = this._getFeature(GraphFileIdProvider.class);
    private OAuth2RequestInterceptor authorizationService;
    private User.Metadata user;

    protected GraphSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public abstract String getFileId(DriveItem.Metadata var1);

    public ODataQuery getQuery(ODataQuery query) {
        if (query == null) {
            query = new ODataQuery();
        }
        query.select(new QueryStringCommaParameter[]{BaseItem.Property.CreatedDateTime, BaseItem.Property.ETag, BaseItem.Property.Id, BaseItem.Property.LastModifiedDateTime, BaseItem.Property.Name, BaseItem.Property.ParentReference, BaseItem.Property.WebUrl, DriveItem.Property.File, DriveItem.Property.FileSystemInfo, DriveItem.Property.Folder, DriveItem.Property.Package, DriveItem.Property.Publication, DriveItem.Property.Size});
        return query;
    }

    public DriveItem getItem(Path currentPath) throws BackgroundException {
        return this.getItem(currentPath, true);
    }

    public DriveItem.Metadata getMetadata(DriveItem item, ODataQuery query) throws IOException {
        return item.getMetadata(this.getQuery(query));
    }

    public abstract DriveItem getItem(Path var1, boolean var2) throws BackgroundException;

    public boolean isAccessible(Path path) {
        return this.isAccessible(path, true);
    }

    public abstract boolean isAccessible(Path var1, boolean var2);

    public abstract ContainerItem getContainer(Path var1);

    public User.Metadata getUser() {
        return this.user;
    }

    protected OneDriveAPI connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt, CancelCallback cancel) throws HostParserException {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(ProxyFactory.get().find(this.host.getProtocol().getOAuthAuthorizationUrl()), (TranscriptListener)this, prompt).build(), this.host.getProtocol()){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (request.containsHeader("Authorization")) {
                    super.process(request, context);
                }
            }
        }.withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl()).withParameter("prompt", "select_account");
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        final GraphCommonsHttpRequestExecutor executor = new GraphCommonsHttpRequestExecutor(configuration.build()){

            public void addAuthorizationHeader(Set<RequestHeader> headers) {
                headers.add(new RequestHeader("Authorization", "Bearer"));
            }
        };
        return new OneDriveAPI(){

            public RequestExecutor getExecutor() {
                return executor;
            }

            public boolean isBusinessConnection() {
                return false;
            }

            public boolean isGraphConnection() {
                String hostname = GraphSession.this.host.getProtocol().getDefaultHostname();
                switch (hostname.toLowerCase()) {
                    case "graph.microsoft.com": 
                    case "graph.microsoft.de": 
                    case "microsoftgraph.chinacloudapi.cn": {
                        return true;
                    }
                }
                return false;
            }

            public String getBaseURL() {
                return String.format("%s://%s/%s", GraphSession.this.host.getProtocol().getScheme(), GraphSession.this.host.getProtocol().getDefaultHostname(), GraphSession.API_VERSION);
            }

            public String getEmailURL() {
                return String.format("%s%s", this.getBaseURL(), "/me");
            }
        };
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel, OAuth2AuthorizationService.FlowType.AuthorizationCode));
        try {
            this.user = Users.get((User)User.getCurrent((OneDriveAPI)((OneDriveAPI)this.client)), (ODataQuery)new ODataQuery().select((QueryStringCommaParameter[])User.Select.values()));
            String account = this.user.getUserPrincipalName();
            if (log.isDebugEnabled()) {
                log.debug(String.format("Authenticated as user %s", account));
            }
            Credentials credentials = this.host.getCredentials();
            credentials.setUsername(account);
            credentials.setSaved(true);
        }
        catch (OneDriveAPIException e) {
            log.warn(String.format("Failure reading current user properties probably missing user.read scope. %s.", e.getMessage()));
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    protected void logout() throws BackgroundException {
        try {
            ((OneDriveAPI)this.client).getExecutor().close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            this.fileid.clear();
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == FileIdProvider.class) {
            return (T)((Object)this.fileid);
        }
        if (type == GraphFileIdProvider.class) {
            return (T)((Object)new GraphFileIdProvider(this));
        }
        if (type == AttributesFinder.class) {
            return (T)new GraphAttributesFinderFeature(this, this.fileid);
        }
        if (type == Directory.class) {
            return (T)new GraphDirectoryFeature(this, this.fileid);
        }
        if (type == Read.class) {
            return (T)new GraphReadFeature(this, this.fileid);
        }
        if (type == Write.class) {
            return (T)new GraphWriteFeature(this, this.fileid);
        }
        if (type == MultipartWrite.class) {
            return (T)new BufferWriteFeature((Session)this);
        }
        if (type == Delete.class) {
            return (T)new GraphDeleteFeature(this, this.fileid);
        }
        if (type == Touch.class) {
            return (T)new GraphTouchFeature(this, this.fileid);
        }
        if (type == Move.class) {
            return (T)new GraphMoveFeature(this, this.fileid);
        }
        if (type == Copy.class) {
            return (T)new GraphCopyFeature(this, this.fileid);
        }
        if (type == Find.class) {
            return (T)new GraphFindFeature(this, this.fileid);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new GraphTimestampFeature(this, this.fileid));
        }
        if (type == Quota.class) {
            return (T)new GraphQuotaFeature(this, this.fileid);
        }
        if (type == UrlProvider.class) {
            return (T)new GraphUrlProvider();
        }
        if (type == PromptUrlProvider.class) {
            return (T)new GraphPromptUrlProvider(this);
        }
        if (type == Versioning.class) {
            return (T)new GraphVersioningFeature(this, this.fileid);
        }
        return (T)super._getFeature(type);
    }

    public static final class ContainerItem {
        public static final ContainerItem EMPTY = new ContainerItem(null, null, false);
        private final Path collectionPath;
        private final Path containerPath;
        private final boolean isDrive;

        public ContainerItem(Path containerPath, Path collectionPath, boolean isDrive) {
            this.containerPath = containerPath;
            this.collectionPath = collectionPath;
            this.isDrive = isDrive;
        }

        public boolean isDrive() {
            return this.isDrive;
        }

        public Optional<Path> getCollectionPath() {
            return Optional.ofNullable(this.collectionPath);
        }

        public Optional<Path> getContainerPath() {
            return Optional.ofNullable(this.containerPath);
        }

        public boolean isDefined() {
            return this.collectionPath != null && this.containerPath != null;
        }

        public boolean isContainerInCollection() {
            if (!this.isDefined()) {
                return false;
            }
            return this.containerPath.isChild(this.collectionPath);
        }

        public boolean isCollectionInContainer() {
            if (!this.isDefined()) {
                return false;
            }
            return this.collectionPath.isChild(this.containerPath);
        }

        public boolean equals(ContainerItem other) {
            if (other == null) {
                return false;
            }
            if (this.isDrive != other.isDrive) {
                return false;
            }
            if (!Objects.equals(this.collectionPath, other.collectionPath)) {
                return false;
            }
            return Objects.equals(this.containerPath, other.containerPath);
        }

        public boolean equals(Object other) {
            return other instanceof ContainerItem && this.equals((ContainerItem)other);
        }
    }
}

