/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.AbstractItemListService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.preferences.HostPreferences;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.types.DriveItem;

public class GraphItemListService
extends AbstractItemListService {
    private static final Logger log = LogManager.getLogger(GraphItemListService.class);
    private final GraphSession session;

    public GraphItemListService(GraphSession session, GraphFileIdProvider fileid) {
        super(new GraphAttributesFinderFeature(session, fileid), fileid);
        this.session = session;
    }

    @Override
    protected Iterator<DriveItem.Metadata> getIterator(Path directory) throws BackgroundException {
        DriveItem folder = this.session.getItem(directory);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Return files for folder %s", folder));
        }
        return Files.getFiles((DriveItem)folder, (ODataQuery)this.session.getQuery(null).top(new HostPreferences(this.session.getHost()).getInteger("onedrive.listing.chunksize")));
    }
}

