/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import ch.cyberduck.core.preferences.PreferencesFactory;
import java.io.IOException;
import java.time.Duration;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.client.HttpResponseException;
import org.nuxeo.onedrive.client.OneDriveAPIException;

public class GraphExceptionMappingService
extends AbstractExceptionMappingService<OneDriveAPIException> {
    private final GraphFileIdProvider fileid;

    public GraphExceptionMappingService(GraphFileIdProvider fileid) {
        this.fileid = fileid;
    }

    public BackgroundException map(String message, OneDriveAPIException failure, Path file) {
        if (failure.getResponseCode() > 0) {
            switch (failure.getResponseCode()) {
                case 404: {
                    this.fileid.cache(file, null);
                }
            }
        }
        return super.map(message, (Throwable)failure, file);
    }

    public BackgroundException map(OneDriveAPIException failure) {
        if (failure.getResponseCode() > 0) {
            StringAppender buffer = new StringAppender();
            buffer.append(failure.getMessage());
            buffer.append(failure.getErrorMessage());
            switch (failure.getResponseCode()) {
                case 429: {
                    if (failure.getRetry() != null) {
                        return new RetriableAccessDeniedException(buffer.toString(), Duration.ofSeconds(failure.getRetry().intValue()));
                    }
                    return new RetriableAccessDeniedException(buffer.toString(), Duration.ofSeconds(PreferencesFactory.get().getInteger("connection.retry.delay")));
                }
            }
            return new DefaultHttpResponseExceptionMappingService().map(new HttpResponseException(failure.getResponseCode(), buffer.toString()));
        }
        if (ExceptionUtils.getRootCause((Throwable)failure) != failure && ExceptionUtils.getRootCause((Throwable)failure) instanceof IOException) {
            return new DefaultIOExceptionMappingService().map((IOException)ExceptionUtils.getRootCause((Throwable)failure));
        }
        return new InteroperabilityException(failure.getMessage(), (Throwable)failure);
    }
}

