/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointSession;
import ch.cyberduck.core.onedrive.features.GraphLockFeature;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.ODataQuery;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.QueryStringCommaParameter;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.GroupItem;
import org.nuxeo.onedrive.client.types.ItemReference;
import org.nuxeo.onedrive.client.types.Site;

public abstract class AbstractSharepointSession
extends GraphSession {
    private static final Logger log = LogManager.getLogger(SharepointSession.class);
    private final Path home;

    public AbstractSharepointSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
        this.home = StringUtils.isNotBlank((CharSequence)host.getDefaultPath()) ? PathNormalizer.compose((Path)Home.ROOT, (String)host.getDefaultPath()) : Home.ROOT;
    }

    public Path getHome() {
        return this.home;
    }

    public boolean isHome(Path file) {
        return new SimplePathPredicate(this.home).test(file);
    }

    public abstract boolean isSingleSite();

    public Site getSite(Path file) throws BackgroundException {
        return Site.byId((OneDriveAPI)((OneDriveAPI)this.client), (String)this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()));
    }

    public GroupItem getGroup(Path file) throws BackgroundException {
        return new GroupItem((OneDriveAPI)this.client, this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener()));
    }

    @Override
    public String getFileId(DriveItem.Metadata metadata) {
        ItemReference parent = metadata.getParentReference();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{parent.getId(), parent.getPath()})) {
            return parent.getDriveId();
        }
        return metadata.getId();
    }

    protected abstract Drive findDrive(GraphSession.ContainerItem var1) throws BackgroundException;

    @Override
    public DriveItem getItem(Path file, boolean resolveLastItem) throws BackgroundException {
        String versionId = this.fileid.getFileId(file, (ListProgressListener)new DisabledListProgressListener());
        if (StringUtils.isEmpty((CharSequence)versionId)) {
            throw new NotfoundException(String.format("Version ID for %s is empty", file.getAbsolute()));
        }
        GraphSession.ContainerItem driveContainer = this.getContainer(file);
        if (!driveContainer.isDrive()) {
            throw new NotfoundException(String.format("File %s is not in a drive.", file.getAbsolute()));
        }
        Drive drive = this.findDrive(driveContainer);
        if (drive == null) {
            throw new NotfoundException(String.format("File %s is not part of any drive.", file.getAbsolute()));
        }
        DriveItem ownItem = driveContainer.getContainerPath().map(arg_0 -> ((Path)file).equals(arg_0)).orElse(false) != false ? drive.getRoot() : new DriveItem(drive, versionId);
        if (resolveLastItem) {
            try {
                DriveItem.Metadata metadata = this.getMetadata(ownItem, new ODataQuery().select((QueryStringCommaParameter)DriveItem.Property.RemoteItem));
                DriveItem.Metadata remoteMetadata = metadata.getRemoteItem();
                if (null != remoteMetadata) {
                    return (DriveItem)remoteMetadata.getItem();
                }
            }
            catch (OneDriveAPIException oneDriveAPIException) {
                throw new GraphExceptionMappingService(this.fileid).map(oneDriveAPIException);
            }
            catch (IOException ioException) {
                throw new DefaultIOExceptionMappingService().map(ioException);
            }
        }
        return ownItem;
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == Lock.class) {
            return (T)new GraphLockFeature(this, this.fileid);
        }
        return super._getFeature(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAccessible(Path file, boolean container) {
        if (file.isRoot()) {
            return false;
        }
        if (file.attributes().isDuplicate()) {
            return false;
        }
        GraphSession.ContainerItem containerItem = this.getContainer(file);
        if (!containerItem.isDefined()) {
            return false;
        }
        if (!containerItem.isDrive()) return false;
        if (container) return true;
        if (containerItem.getContainerPath().map(arg_0 -> ((Path)file).equals(arg_0)).orElse(false) != false) return false;
        return true;
    }

    protected Deque<Path> decompose(Path file) {
        ArrayDeque<Path> walk = new ArrayDeque<Path>();
        Path next = file;
        while (!next.isRoot()) {
            walk.push(next);
            next = next.getParent();
        }
        return walk;
    }
}

