/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.onedrive.AbstractListService;
import ch.cyberduck.core.onedrive.features.GraphFileIdProvider;
import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.onedrive.client.types.Drive;
import org.nuxeo.onedrive.client.types.Quota;

public abstract class AbstractDriveListService
extends AbstractListService<Drive.Metadata> {
    private static final Logger log = LogManager.getLogger(AbstractDriveListService.class);

    public AbstractDriveListService(GraphFileIdProvider fileid) {
        super(fileid);
    }

    @Override
    protected Path toPath(Drive.Metadata metadata, Path directory) {
        Long used;
        PathAttributes attributes = new PathAttributes();
        attributes.setFileId(metadata.getId());
        Quota quota = metadata.getQuota();
        if (quota != null && (used = quota.getUsed()) != null) {
            attributes.setSize(used.longValue());
        }
        String name = metadata.getName();
        if (StringUtils.isBlank((CharSequence)metadata.getName())) {
            name = metadata.getId();
        }
        return new Path(directory, name, EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), attributes);
    }
}

