/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.comparator;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.ui.comparator.BrowserComparator;
import ch.cyberduck.ui.comparator.FilenameComparator;

public class ChecksumComparator
extends BrowserComparator {
    public ChecksumComparator(boolean ascending) {
        super(ascending, new FilenameComparator(ascending));
    }

    @Override
    protected int compareFirst(Path p1, Path p2) {
        if (Checksum.NONE.equals(p1.attributes().getChecksum()) && Checksum.NONE.equals(p2.attributes().getChecksum())) {
            return 0;
        }
        if (Checksum.NONE.equals(p1.attributes().getChecksum())) {
            return -1;
        }
        if (Checksum.NONE.equals(p2.attributes().getChecksum())) {
            return 1;
        }
        if (this.ascending) {
            return p1.attributes().getChecksum().hash.compareToIgnoreCase(p2.attributes().getChecksum().hash);
        }
        return -p1.attributes().getChecksum().hash.compareToIgnoreCase(p2.attributes().getChecksum().hash);
    }
}

