/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.browser;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.SimplePathPredicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecursiveSearchFilter
extends NullFilter<Path> {
    private static final Logger log = LogManager.getLogger(RecursiveSearchFilter.class);
    private final AttributedList<Path> list;

    public RecursiveSearchFilter(AttributedList<Path> list) {
        this.list = list;
    }

    @Override
    public boolean accept(Path file) {
        if (this.list.find(new SimplePathPredicate(file)) != null) {
            return true;
        }
        for (Path f : this.list) {
            if (!f.isChild(file)) continue;
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Filter %s", file));
        }
        return false;
    }
}

