/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.ui.browser;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.ui.browser.DirectoryFinder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadDirectoryFinder
implements DirectoryFinder {
    private static final Logger log = LogManager.getLogger(DownloadDirectoryFinder.class);
    private final AbstractHostCollection collection = BookmarkCollection.defaultCollection();
    private final Preferences preferences = PreferencesFactory.get();

    @Override
    public Local find(Host bookmark) {
        if (null != bookmark.getDownloadFolder() && bookmark.getDownloadFolder().exists()) {
            return bookmark.getDownloadFolder();
        }
        Local directory = LocalFactory.get(this.preferences.getProperty("queue.download.folder")).withBookmark(this.preferences.getProperty("queue.download.folder.bookmark"));
        if (log.isInfoEnabled()) {
            log.info(String.format("Suggest default download folder %s for bookmark %s", directory, bookmark));
        }
        return directory;
    }

    @Override
    public void save(Host bookmark, Local directory) {
        if (!directory.exists()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info(String.format("Save default download folder %s for bookmark %s", directory, bookmark));
        }
        bookmark.setDownloadFolder(directory);
        if (this.collection.contains(bookmark)) {
            this.collection.collectionItemChanged(bookmark);
        }
    }
}

