/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WriteTransferAccelerationWorker
extends Worker<Boolean> {
    private static final Logger log = LogManager.getLogger(WriteTransferAccelerationWorker.class);
    private final List<Path> files;
    private final boolean enabled;

    public WriteTransferAccelerationWorker(List<Path> files, boolean enabled) {
        this.files = files;
        this.enabled = enabled;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        TransferAcceleration feature = session.getFeature(TransferAcceleration.class);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run with feature %s", feature));
        }
        PathContainerService container = session.getFeature(PathContainerService.class);
        for (Path file : this.getContainers(container, this.files)) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            this.write(feature, file);
        }
        return true;
    }

    private void write(TransferAcceleration feature, Path file) throws BackgroundException {
        feature.setStatus(file, this.enabled);
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteTransferAccelerationWorker that = (WriteTransferAccelerationWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WriteTransferAccelerationWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

