/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WriteTimestampWorker
extends Worker<Boolean> {
    private static final Logger log = LogManager.getLogger(WriteTimestampWorker.class);
    private final Path file;
    private final Long timestamp;

    public WriteTimestampWorker(Path file, Long timestamp) {
        this.file = file;
        this.timestamp = timestamp;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        Timestamp feature = session.getFeature(Timestamp.class);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run with feature %s", feature));
        }
        feature.setTimestamp(this.file, new TransferStatus().withTimestamp(this.timestamp).withLockId(this.getLockId(this.file)));
        return true;
    }

    protected String getLockId(Path file) {
        return null;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Changing timestamp of {0} to {1}", "Status"), this.file.getName(), UserDateFormatterFactory.get().getShortFormat(this.timestamp));
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteTimestampWorker that = (WriteTimestampWorker)o;
        return Objects.equals(this.file, that.file) && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.file, this.timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("WriteTimestampWorker{");
        sb.append("file=").append(this.file);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append('}');
        return sb.toString();
    }
}

