/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VersionsWorker
extends Worker<AttributedList<Path>> {
    private static final Logger log = LogManager.getLogger(VersionsWorker.class);
    private final Path file;
    private final ListProgressListener listener;

    public VersionsWorker(Path file, ListProgressListener listener) {
        this.file = file;
        this.listener = listener;
    }

    @Override
    public AttributedList<Path> run(Session<?> session) throws BackgroundException {
        if (this.file.isDirectory()) {
            return AttributedList.emptyList();
        }
        Versioning feature = session.getFeature(Versioning.class);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run with feature %s", feature));
        }
        return feature.list(this.file, this.listener);
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), this.file.getName());
    }

    @Override
    public AttributedList<Path> initialize() {
        return AttributedList.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionsWorker that = (VersionsWorker)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return Objects.hash(this.file);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("VersionsWorker{");
        sb.append("file=").append(this.file);
        sb.append('}');
        return sb.toString();
    }
}

