/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SearchWorker
extends Worker<AttributedList<Path>> {
    private static final Logger log = LogManager.getLogger(SearchWorker.class);
    private final Path directory;
    private final Filter<Path> filter;
    private final Cache<Path> cache;
    private final ListProgressListener listener;

    public SearchWorker(Path directory, Filter<Path> filter, Cache<Path> cache, ListProgressListener listener) {
        this.directory = directory;
        this.filter = filter;
        this.cache = cache;
        this.listener = listener;
    }

    @Override
    public AttributedList<Path> run(Session<?> session) throws BackgroundException {
        Search feature = session.getFeature(Search.class);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run with feature %s", feature));
        }
        return this.search(feature, this.directory);
    }

    private AttributedList<Path> search(Search search, Path workdir) throws BackgroundException {
        AttributedList<Path> list;
        if (this.isCanceled()) {
            throw new ConnectionCanceledException();
        }
        if (!search.isRecursive() && this.cache.isCached(workdir)) {
            list = new AttributedList<Path>(this.cache.get(workdir));
        } else {
            list = search.search(workdir, new RecursiveSearchFilter(this.filter), new WorkerListProgressListener(this, this.listener));
            if (search.isRecursive()) {
                return list;
            }
            this.cache.put(workdir, new AttributedList<Path>(list));
        }
        final HashSet<Path> removal = new HashSet<Path>();
        for (Path file : list) {
            if (!file.isDirectory()) continue;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Recursively search in %s", file));
            }
            AttributedList<Path> children = this.search(search, file);
            list.addAll(children);
            if (!children.isEmpty()) continue;
            removal.add(file);
        }
        return list.filter((Filter<Path>)new NullFilter<Path>(){

            @Override
            public boolean accept(Path file) {
                return !removal.contains(file);
            }
        }).filter(new RecursiveSearchFilter(this.filter));
    }

    @Override
    public AttributedList<Path> initialize() {
        return AttributedList.emptyList();
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Searching in {0}", "Status"), this.directory.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchWorker)) {
            return false;
        }
        SearchWorker that = (SearchWorker)o;
        return Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.filter);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SearchWorker{");
        sb.append("filter='").append(this.filter).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private static final class RecursiveSearchFilter
    implements Filter<Path> {
        private final Filter<Path> filter;

        public RecursiveSearchFilter(Filter<Path> filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(Path file) {
            if (file.isDirectory()) {
                return true;
            }
            return this.filter.accept(file);
        }

        @Override
        public Pattern toPattern() {
            return this.filter.toPattern();
        }

        public int hashCode() {
            return this.filter.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Filter) {
                return this.filter.equals(obj);
            }
            return false;
        }
    }
}

