/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReadAclWorker
extends Worker<List<Acl.UserAndRole>> {
    private static final Logger log = LogManager.getLogger(ReadAclWorker.class);
    private final List<Path> files;

    public ReadAclWorker(List<Path> files) {
        this.files = files;
    }

    @Override
    public List<Acl.UserAndRole> run(Session<?> session) throws BackgroundException {
        AclPermission feature = session.getFeature(AclPermission.class);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Run with feature %s", feature));
        }
        ArrayList<Acl.UserAndRole> updated = new ArrayList<Acl.UserAndRole>();
        for (Path next : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            if (Acl.EMPTY == next.attributes().getAcl()) {
                next.attributes().setAcl(feature.getPermission(next));
            }
            for (Acl.UserAndRole acl : next.attributes().getAcl().asList()) {
                if (updated.contains(acl)) continue;
                updated.add(acl);
            }
        }
        return updated;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Getting permission of {0}", "Status"), this.toString(this.files));
    }

    @Override
    public List<Acl.UserAndRole> initialize() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadAclWorker that = (ReadAclWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReadAclWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

