/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingAttributesFinderFeature;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.MappingMimeTypeService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import ch.cyberduck.ui.comparator.VersionsComparator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MoveWorker
extends Worker<Map<Path, Path>> {
    private static final Logger log = LogManager.getLogger(MoveWorker.class);
    private final Map<Path, Path> files;
    private final SessionPool target;
    private final Cache<Path> cache;
    private final ProgressListener listener;
    private final ConnectionCallback callback;

    public MoveWorker(Map<Path, Path> files, SessionPool target, Cache<Path> cache, ProgressListener listener, ConnectionCallback callback) {
        this.files = files;
        this.target = target;
        this.cache = cache;
        this.listener = listener;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Path, Path> run(Session<?> session) throws BackgroundException {
        Session<?> destination = this.target.borrow(new BackgroundActionState(){

            @Override
            public boolean isCanceled() {
                return MoveWorker.this.isCanceled();
            }

            @Override
            public boolean isRunning() {
                return true;
            }
        });
        try {
            Move feature = session.getFeature(Move.class).withTarget(destination);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Run with feature %s", feature));
            }
            ListService list = session.getFeature(ListService.class);
            TreeMap<Path, Path> sorted = new TreeMap<Path, Path>(new VersionsComparator(true));
            sorted.putAll(this.files);
            HashMap<Path, Path> result = new HashMap<Path, Path>();
            for (Map.Entry entry : sorted.entrySet()) {
                if (this.isCanceled()) {
                    throw new ConnectionCanceledException();
                }
                Map<Path, Path> recursive = this.compile(feature, list, (Path)entry.getKey(), (Path)entry.getValue());
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Compiled recursive list %s", recursive));
                }
                for (Map.Entry<Path, Path> r : recursive.entrySet()) {
                    Path moved;
                    if (r.getKey().isDirectory() && !feature.isRecursive(r.getKey(), r.getValue())) {
                        log.warn(String.format("Move operation is not recursive. Create directory %s", r.getValue()));
                        result.put(r.getKey(), session.getFeature(Directory.class).mkdir(r.getValue(), new TransferStatus().withRegion(r.getKey().attributes().getRegion())));
                        continue;
                    }
                    TransferStatus status = new TransferStatus().withLockId(this.getLockId(r.getKey())).withMime(new MappingMimeTypeService().getMime(r.getValue().getName())).exists(new CachingFindFeature(this.cache, session.getFeature(Find.class, new DefaultFindFeature(session))).find(r.getValue())).withLength(r.getKey().attributes().getSize());
                    if (status.isExists()) {
                        status.withRemote(new CachingAttributesFinderFeature(this.cache, session.getFeature(AttributesFinder.class, new DefaultAttributesFinderFeature(session))).find(r.getValue()));
                    }
                    if (PathAttributes.EMPTY.equals((moved = feature.move(r.getKey(), r.getValue(), status, new Delete.Callback(){

                        @Override
                        public void delete(Path file) {
                            MoveWorker.this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), file.getName()));
                        }
                    }, this.callback)).attributes())) {
                        moved.withAttributes(session.getFeature(AttributesFinder.class).find(moved));
                    }
                    result.put(r.getKey(), moved);
                }
                List folders = recursive.entrySet().stream().filter(f -> !feature.isRecursive((Path)f.getKey(), (Path)f.getValue())).collect(Collectors.toCollection(ArrayList::new)).stream().map(Map.Entry::getKey).filter(Path::isDirectory).collect(Collectors.toCollection(ArrayList::new));
                if (folders.isEmpty()) continue;
                Collections.reverse(folders);
                Delete delete = session.getFeature(Delete.class);
                for (Path folder : folders) {
                    log.warn(String.format("Delete source directory %s", folder));
                    TransferStatus status = new TransferStatus().withLockId(this.getLockId(folder));
                    delete.delete(Collections.singletonMap(folder, status), (PasswordCallback)this.callback, (Delete.Callback)new Delete.DisabledCallback());
                }
            }
            HashMap<Path, Path> hashMap = result;
            return hashMap;
        }
        finally {
            this.target.release(destination, null);
        }
    }

    protected String getLockId(Path file) {
        return null;
    }

    protected Map<Path, Path> compile(Move move, ListService list, Path source, Path target) throws BackgroundException {
        LinkedHashMap<Path, Path> recursive = new LinkedHashMap<Path, Path>();
        recursive.put(source, target);
        if (source.isDirectory() && !move.isRecursive(source, target)) {
            AttributedList<Path> children = list.list(source, new WorkerListProgressListener(this, this.listener)).filter(new VersionsComparator(true));
            for (Path child : children) {
                if (this.isCanceled()) {
                    throw new ConnectionCanceledException();
                }
                recursive.putAll(this.compile(move, list, child, new Path(target, child.getName(), child.getType())));
            }
        }
        return recursive;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Renaming {0} to {1}", "Status"), this.files.keySet().iterator().next().getName(), this.files.values().iterator().next().getName());
    }

    @Override
    public Map<Path, Path> initialize() {
        return Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoveWorker that = (MoveWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MoveWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

