/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.preferences.HostPreferences;
import ch.cyberduck.core.vault.VaultLookupListener;
import ch.cyberduck.core.worker.Worker;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class LoadVaultWorker
extends Worker<Vault> {
    private final VaultLookupListener listener;
    private final Path directory;

    public LoadVaultWorker(VaultLookupListener listener, Path directory) {
        this.listener = listener;
        this.directory = directory;
    }

    @Override
    public Vault run(Session<?> session) throws BackgroundException {
        return this.listener.load(session, this.directory, new HostPreferences(session.getHost()).getProperty("cryptomator.vault.masterkey.filename"), new HostPreferences(session.getHost()).getProperty("cryptomator.vault.config.filename"), new HostPreferences(session.getHost()).getProperty("cryptomator.vault.pepper").getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getActivity() {
        return LocaleFactory.localizedString("Unlock Vault", "Cryptomator");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadVaultWorker that = (LoadVaultWorker)o;
        return Objects.equals(this.directory, that.directory);
    }

    public int hashCode() {
        return Objects.hash(this.directory);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("LoadVaultWorker{");
        sb.append("directory=").append(this.directory);
        sb.append('}');
        return sb.toString();
    }
}

