/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.DistributionConfiguration;
import ch.cyberduck.core.cdn.features.Purge;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DistributionPurgeWorker
extends Worker<Boolean> {
    private static final Logger log = LogManager.getLogger(DistributionPurgeWorker.class);
    private final List<Path> files;
    private final LoginCallback prompt;
    private final Distribution.Method[] methods;

    public DistributionPurgeWorker(List<Path> files, LoginCallback prompt, Distribution.Method ... methods) {
        this.files = files;
        this.prompt = prompt;
        this.methods = methods;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        DistributionConfiguration cdn = session.getFeature(DistributionConfiguration.class);
        if (null == cdn) {
            log.warn(String.format("Missing CDN support in %s", session));
            return false;
        }
        for (Distribution.Method method : this.methods) {
            Purge feature = cdn.getFeature(Purge.class, method);
            if (null == feature) {
                log.warn(String.format("Missing purge support in %s", cdn));
                continue;
            }
            PathContainerService container = session.getFeature(PathContainerService.class);
            for (Path file : this.getContainers(container, this.files)) {
                if (this.isCanceled()) {
                    throw new ConnectionCanceledException();
                }
                feature.invalidate(file, method, this.files, this.prompt);
            }
        }
        return true;
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Writing CDN configuration of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionPurgeWorker that = (DistributionPurgeWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DistributionPurgeWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

