/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Trash;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeleteWorker
extends Worker<List<Path>> {
    private static final Logger log = LogManager.getLogger(DeleteWorker.class);
    private final List<Path> files;
    private final LoginCallback prompt;
    private final ProgressListener listener;
    private final Filter<Path> filter;
    private final boolean trash;
    private final Delete.Callback callback;

    public DeleteWorker(LoginCallback prompt, List<Path> files, ProgressListener listener) {
        this(prompt, files, listener, new NullFilter<Path>());
    }

    public DeleteWorker(LoginCallback prompt, List<Path> files, ProgressListener listener, Filter<Path> filter) {
        this(prompt, files, listener, filter, PreferencesFactory.get().getBoolean("browser.delete.trash"));
    }

    public DeleteWorker(LoginCallback prompt, List<Path> files, ProgressListener listener, boolean trash) {
        this(prompt, files, listener, new NullFilter<Path>(), trash);
    }

    public DeleteWorker(LoginCallback prompt, List<Path> files, ProgressListener listener, Filter<Path> filter, boolean trash) {
        this(prompt, files, listener, filter, trash, new Delete.DisabledCallback());
    }

    public DeleteWorker(LoginCallback prompt, List<Path> files, ProgressListener listener, Filter<Path> filter, boolean trash, Delete.Callback callback) {
        this.files = files;
        this.prompt = prompt;
        this.listener = listener;
        this.filter = filter;
        this.trash = trash;
        this.callback = callback;
    }

    @Override
    public List<Path> run(Session<?> session) throws BackgroundException {
        Delete delete;
        if (this.trash) {
            if (null == session.getFeature(Trash.class)) {
                log.warn(String.format("No trash feature available for %s", session));
                delete = session.getFeature(Delete.class);
            } else {
                delete = session.getFeature(Trash.class);
            }
        } else {
            delete = session.getFeature(Delete.class);
        }
        ListService list = session.getFeature(ListService.class);
        LinkedHashMap<Path, TransferStatus> recursive = new LinkedHashMap<Path, TransferStatus>();
        for (Path file : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            recursive.putAll(this.compile(session.getHost(), delete, list, new WorkerListProgressListener(this, this.listener), file));
        }
        if (delete.isRecursive()) {
            recursive.keySet().removeIf(f -> recursive.keySet().stream().anyMatch(f::isChild));
        }
        delete.delete(recursive, (PasswordCallback)this.prompt, new Delete.Callback(){

            @Override
            public void delete(Path file) {
                DeleteWorker.this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), file.getName()));
                DeleteWorker.this.callback.delete(file);
                if (file.isDirectory() && delete.isRecursive()) {
                    DeleteWorker.this.files.stream().filter(f -> f.isChild(file)).forEach(DeleteWorker.this.callback::delete);
                }
            }
        });
        return new ArrayList<Path>(recursive.keySet());
    }

    protected Map<Path, TransferStatus> compile(Host host, Delete delete, ListService list, ListProgressListener listener, Path file) throws BackgroundException {
        LinkedHashMap<Path, TransferStatus> recursive = new LinkedHashMap<Path, TransferStatus>();
        if (file.isFile() || file.isSymbolicLink()) {
            if (null != file.attributes().getVersionId()) {
                if (file.attributes().isDuplicate()) {
                    log.warn(String.format("Delete version %s", file));
                } else if (file.getType().contains((Object)AbstractPath.Type.upload)) {
                    log.warn(String.format("Delete pending upload %s", file));
                } else {
                    log.warn(String.format("Nullify version to add delete marker for %s", file));
                    file.attributes().setVersionId(null);
                }
            }
            recursive.put(file, new TransferStatus().withLockId(this.getLockId(file)));
        } else if (file.isDirectory()) {
            if (!delete.isRecursive()) {
                for (Path child : list.list(file, listener).filter(this.filter)) {
                    if (this.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                    recursive.putAll(this.compile(host, delete, list, listener, child));
                }
            }
            recursive.put(file, new TransferStatus().withLockId(this.getLockId(file)));
        }
        return recursive;
    }

    protected String getLockId(Path file) {
        return null;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), this.toString(this.files));
    }

    @Override
    public List<Path> initialize() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteWorker)) {
            return false;
        }
        DeleteWorker that = (DeleteWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return Objects.hash(this.files);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("DeleteWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

