/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CachingFindFeature;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.MappingMimeTypeService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import ch.cyberduck.ui.comparator.TimestampComparator;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CopyWorker
extends Worker<Map<Path, Path>> {
    private final Map<Path, Path> files;
    private final SessionPool target;
    private final ProgressListener listener;
    private final Cache<Path> cache;
    private final ConnectionCallback callback;

    public CopyWorker(Map<Path, Path> files, SessionPool target, Cache<Path> cache, ProgressListener listener, ConnectionCallback callback) {
        this.files = files;
        this.target = target;
        this.listener = listener;
        this.cache = cache;
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Path, Path> run(Session<?> session) throws BackgroundException {
        Session<?> destination = this.target.borrow(new BackgroundActionState(){

            @Override
            public boolean isCanceled() {
                return CopyWorker.this.isCanceled();
            }

            @Override
            public boolean isRunning() {
                return true;
            }
        });
        try {
            Copy copy = session.getFeature(Copy.class).withTarget(destination);
            ListService list = session.getFeature(ListService.class);
            HashMap<Path, Path> result = new HashMap<Path, Path>();
            for (Map.Entry<Path, Path> entry : this.files.entrySet()) {
                if (this.isCanceled()) {
                    throw new ConnectionCanceledException();
                }
                Map<Path, Path> recursive = this.compile(copy, list, entry.getKey(), entry.getValue());
                for (Map.Entry<Path, Path> r : recursive.entrySet()) {
                    if (r.getKey().isDirectory() && !copy.isRecursive(r.getKey(), r.getValue())) {
                        Directory directory = session.getFeature(Directory.class);
                        result.put(r.getKey(), directory.mkdir(r.getValue(), new TransferStatus().withRegion(r.getKey().attributes().getRegion())));
                        continue;
                    }
                    TransferStatus status = new TransferStatus().withMime(new MappingMimeTypeService().getMime(r.getValue().getName())).exists(new CachingFindFeature(this.cache, session.getFeature(Find.class, new DefaultFindFeature(session))).find(r.getValue())).withLength(r.getKey().attributes().getSize());
                    Path copied = copy.copy(r.getKey(), r.getValue(), status, this.callback, new DisabledStreamListener());
                    if (PathAttributes.EMPTY.equals(copied.attributes())) {
                        copied.withAttributes(session.getFeature(AttributesFinder.class).find(copied));
                    }
                    result.put(r.getKey(), copied);
                }
            }
            HashMap<Path, Path> hashMap = result;
            return hashMap;
        }
        finally {
            this.target.release(destination, null);
        }
    }

    protected Map<Path, Path> compile(Copy copy, ListService list, Path source, Path target) throws BackgroundException {
        LinkedHashMap<Path, Path> recursive = new LinkedHashMap<Path, Path>();
        if (source.isFile() || source.isSymbolicLink()) {
            recursive.put(source, target);
        } else if (source.isDirectory()) {
            recursive.put(source, target);
            if (!copy.isRecursive(source, target)) {
                AttributedList<Path> children = list.list(source, new WorkerListProgressListener(this, this.listener)).filter(new TimestampComparator(true));
                for (Path child : children) {
                    if (this.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                    recursive.putAll(this.compile(copy, list, child, new Path(target, child.getName(), child.getType())));
                }
            }
        }
        return recursive;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Copying {0} to {1}", "Status"), this.files.keySet().iterator().next().getName(), this.files.values().iterator().next().getName());
    }

    @Override
    public Map<Path, Path> initialize() {
        return Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CopyWorker that = (CopyWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("CopyWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

