/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AlphanumericRandomStringService;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.pool.SessionPool;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.AutoTransferConnectionLimiter;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferErrorCallback;
import ch.cyberduck.core.transfer.TransferOptions;
import ch.cyberduck.core.transfer.TransferPrompt;
import ch.cyberduck.core.transfer.TransferSpeedometer;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.AbstractTransferWorker;
import ch.cyberduck.core.worker.DefaultExceptionMappingService;
import ch.cyberduck.core.worker.TransferWorker;
import com.google.common.base.Throwables;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConcurrentTransferWorker
extends AbstractTransferWorker {
    private static final Logger log = LogManager.getLogger(ConcurrentTransferWorker.class);
    private final SessionPool source;
    private final SessionPool destination;
    private final CompletionService<TransferStatus> completion;
    private final AtomicInteger size = new AtomicInteger();
    private final ThreadPool pool;

    public ConcurrentTransferWorker(SessionPool source, SessionPool destination, Transfer transfer, TransferOptions options, TransferSpeedometer meter, TransferPrompt prompt, TransferErrorCallback error, ConnectionCallback connect, ProgressListener progressListener, StreamListener streamListener, NotificationService notification) {
        this(source, destination, transfer, ThreadPool.Priority.norm, options, meter, prompt, error, connect, progressListener, streamListener, notification);
    }

    public ConcurrentTransferWorker(SessionPool source, SessionPool destination, Transfer transfer, ThreadPool.Priority priority, TransferOptions options, TransferSpeedometer meter, TransferPrompt prompt, TransferErrorCallback error, ConnectionCallback connect, ProgressListener progressListener, StreamListener streamListener, NotificationService notification) {
        super(transfer, options, prompt, meter, error, progressListener, streamListener, connect, notification);
        this.source = source;
        this.destination = destination;
        this.pool = ThreadPoolFactory.get(String.format("%s-transfer", new AlphanumericRandomStringService().random()), new AutoTransferConnectionLimiter().getLimit(transfer.getSource()), priority, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE));
        this.completion = new ExecutorCompletionService<TransferStatus>(this.pool.executor());
    }

    @Override
    protected Session<?> borrow(AbstractTransferWorker.Connection type) throws BackgroundException {
        switch (type) {
            case source: {
                return this.source.borrow(new BackgroundActionState(){

                    @Override
                    public boolean isCanceled() {
                        return ConcurrentTransferWorker.this.isCanceled();
                    }

                    @Override
                    public boolean isRunning() {
                        return true;
                    }
                });
            }
            case destination: {
                return this.destination.borrow(new BackgroundActionState(){

                    @Override
                    public boolean isCanceled() {
                        return ConcurrentTransferWorker.this.isCanceled();
                    }

                    @Override
                    public boolean isRunning() {
                        return true;
                    }
                });
            }
        }
        return null;
    }

    @Override
    protected void release(Session session, AbstractTransferWorker.Connection type, BackgroundException failure) {
        switch (type) {
            case source: {
                this.source.release(session, failure);
                break;
            }
            case destination: {
                this.destination.release(session, failure);
            }
        }
    }

    @Override
    public Future<TransferStatus> submit(TransferWorker.TransferCallable callable) {
        if (log.isInfoEnabled()) {
            log.info(String.format("Submit %s to pool", callable));
        }
        Future<TransferStatus> f = this.completion.submit(callable);
        this.size.incrementAndGet();
        return f;
    }

    @Override
    public void await() throws BackgroundException {
        while (this.size.get() > 0) {
            try {
                if (log.isInfoEnabled()) {
                    log.info(String.format("Await completion for %d submitted tasks in queue", this.size.get()));
                }
                TransferStatus status = this.completion.take().get();
                if (!log.isInfoEnabled()) continue;
                log.info(String.format("Finished task with return value %s", status));
            }
            catch (InterruptedException e) {
                log.warn(String.format("Unhandled failure %s", e));
                throw new ConnectionCanceledException(e);
            }
            catch (ExecutionException e) {
                Throwables.throwIfInstanceOf((Throwable)Throwables.getRootCause((Throwable)e), BackgroundException.class);
                throw new DefaultExceptionMappingService().map(Throwables.getRootCause((Throwable)e));
            }
            finally {
                this.size.decrementAndGet();
            }
        }
    }

    @Override
    protected void shutdown() {
        this.pool.shutdown(true);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ConcurrentTransferWorker{");
        sb.append("source=").append(this.source);
        sb.append(", destination=").append(this.destination);
        sb.append(", pool=").append(this.completion);
        sb.append('}');
        return sb.toString();
    }
}

