/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.VersionIdProvider;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryVersionIdProvider
implements VersionIdProvider {
    private final Session<?> session;
    private final VersionIdProvider proxy;
    private final VaultRegistry registry;

    public VaultRegistryVersionIdProvider(Session<?> session, VersionIdProvider proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public String getVersionId(Path file, ListProgressListener listener) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, VersionIdProvider.class, this.proxy).getVersionId(file, listener);
    }

    @Override
    public void clear() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryIdProvider{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

