/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryUploadFeature<Output>
implements Upload<Output> {
    private final Session<?> session;
    private final Upload<Output> proxy;
    private final VaultRegistry registry;

    public VaultRegistryUploadFeature(Session<?> session, Upload<Output> proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Output upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Upload.class, this.proxy).upload(file, local, throttle, listener, status, callback);
    }

    @Override
    public Write.Append append(Path file, TransferStatus status) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Upload.class, this.proxy).append(file, status);
    }

    @Override
    public Upload<Output> withWriter(Write<Output> writer) {
        this.proxy.withWriter(writer);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryUploadFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

